/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.web;

import java.util.ArrayList;
import java.util.Arrays;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.J2eeProjectCapabilities;
import org.netbeans.modules.j2ee.common.ProjectUtil;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.openide.filesystems.FileObject;

@SuppressWarnings(value={"EI_EXPOSE_REP"})
public class WebRecoPrivTemplates
implements RecommendedTemplates,
PrivilegedTemplates {
    private Project project;
    private static final String[] WEB_TYPES = new String[]{"html5", "servlet-types", "web-types", "web-types-server"};
    private static final String[] WEB_TYPES_5 = new String[]{"html5", "servlet-types", "web-types", "web-types-server", "web-services", "web-service-clients", "REST-clients"};
    private static final String[] WEB_TYPES_6 = WEB_TYPES_5;
    private static final String[] WEB_TYPES_EJB = new String[]{"ejb-types", "ejb-types-server", "ejb-types_3_0", "ejb-types_3_1", "ejb-types_3_1_full", "ejb-deployment-descriptor"};
    private static final String[] WEB_TYPES_EJB_LITE = new String[]{"ejb-types", "ejb-types_3_0", "ejb-types_3_1", "ejb-deployment-descriptor"};
    private static final String[] WEB_TYPES_EJB32_LITE = new String[]{"ejb-types", "ejb-types_3_0", "ejb-types_3_1", "ejb-types_3_2", "ejb-deployment-descriptor"};
    private static final String[] WEB_PRIVILEGED_NAMES = new String[]{"Templates/JSP_Servlet/JSP.jsp", "Templates/JSP_Servlet/Html.html", "Templates/JSP_Servlet/Servlet.java", "Templates/Classes/Class.java", "Templates/Classes/Package", "Templates/Other/Folder"};
    private static final String[] WEB_PRIVILEGED_NAMES_5 = new String[]{"Templates/JSP_Servlet/JSP.jsp", "Templates/JSP_Servlet/Html.html", "Templates/JSP_Servlet/Servlet.java", "Templates/Classes/Class.java", "Templates/Classes/Package", "Templates/Persistence/Entity.java", "Templates/Persistence/RelatedCMP", "Templates/Persistence/JsfFromDB", "Templates/WebServices/WebService.java", "Templates/WebServices/WebServiceClient", "Templates/WebServices/RestServicesFromDatabase", "Templates/Other/Folder"};
    private static final String[] WEB_PRIVILEGED_NAMES_6 = WEB_PRIVILEGED_NAMES_5;
    private static final String[] WEB_PRIVILEGED_NAMES_EE6_FULL = new String[]{"Templates/J2EE/Session", "Templates/J2EE/Message"};
    private static final String[] WEB_PRIVILEGED_NAMES_EE6_WEB = new String[]{"Templates/J2EE/Session"};
    private static final String[] WEB_PRIVILEGED_NAMES_EE7_WEB = new String[]{"Templates/J2EE/TimerSession"};

    public WebRecoPrivTemplates(Project project) {
        this.project = project;
    }

    public String[] getRecommendedTypes() {
        WebModule web = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (web != null) {
            Profile p = web.getJ2eeProfile();
            if (Profile.JAVA_EE_5.equals(p)) {
                return WEB_TYPES_5;
            }
            if (p != null && p.isAtLeast(Profile.JAVA_EE_6_WEB)) {
                ArrayList<String> toRet = new ArrayList<String>(Arrays.asList(WEB_TYPES_6));
                J2eeProjectCapabilities cap = J2eeProjectCapabilities.forProject((Project)this.project);
                if (cap != null) {
                    if (cap.isEjb31Supported() || this.isServerSupportingEJB31()) {
                        toRet.addAll(Arrays.asList(WEB_TYPES_EJB));
                    } else if (cap.isEjb32LiteSupported() || cap.isEjb40LiteSupported()) {
                        toRet.addAll(Arrays.asList(WEB_TYPES_EJB32_LITE));
                    } else if (cap.isEjb31LiteSupported()) {
                        toRet.addAll(Arrays.asList(WEB_TYPES_EJB_LITE));
                    }
                }
                return toRet.toArray(new String[0]);
            }
        }
        return WEB_TYPES;
    }

    public String[] getPrivilegedTemplates() {
        WebModule web = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (web != null) {
            Profile p = web.getJ2eeProfile();
            if (Profile.JAVA_EE_5.equals(p)) {
                return WEB_PRIVILEGED_NAMES_5;
            }
            if (p != null && p.isAtLeast(Profile.JAVA_EE_6_WEB)) {
                ArrayList<String> toRet = new ArrayList<String>(Arrays.asList(WEB_PRIVILEGED_NAMES_6));
                J2eeProjectCapabilities cap = J2eeProjectCapabilities.forProject((Project)this.project);
                if (cap != null) {
                    if (cap.isEjb31Supported() || this.isServerSupportingEJB31()) {
                        toRet.addAll(Arrays.asList(WEB_PRIVILEGED_NAMES_EE6_FULL));
                    }
                    if (cap.isEjb31LiteSupported()) {
                        toRet.addAll(Arrays.asList(WEB_PRIVILEGED_NAMES_EE6_WEB));
                    }
                    if (cap.isEjb32LiteSupported() || cap.isEjb40LiteSupported()) {
                        toRet.addAll(Arrays.asList(WEB_PRIVILEGED_NAMES_EE7_WEB));
                    }
                }
                return toRet.toArray(new String[0]);
            }
        }
        return WEB_PRIVILEGED_NAMES;
    }

    private boolean isServerSupportingEJB31() {
        return ProjectUtil.getSupportedProfiles((Project)this.project).contains(Profile.JAVA_EE_6_FULL) || ProjectUtil.getSupportedProfiles((Project)this.project).contains(Profile.JAVA_EE_7_FULL) || ProjectUtil.getSupportedProfiles((Project)this.project).contains(Profile.JAVA_EE_8_FULL) || ProjectUtil.getSupportedProfiles((Project)this.project).contains(Profile.JAKARTA_EE_8_FULL) || ProjectUtil.getSupportedProfiles((Project)this.project).contains(Profile.JAKARTA_EE_9_FULL) || ProjectUtil.getSupportedProfiles((Project)this.project).contains(Profile.JAKARTA_EE_9_1_FULL) || ProjectUtil.getSupportedProfiles((Project)this.project).contains(Profile.JAKARTA_EE_10_FULL);
    }
}

