/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RepositoryObject {
    @JsonProperty(value="type")
    private final Type type;
    @JsonProperty(value="sizeInBytes")
    private final Long sizeInBytes;
    @JsonProperty(value="sha")
    private final String sha;
    @JsonProperty(value="isBinary")
    private final Boolean isBinary;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().type(this.type).sizeInBytes(this.sizeInBytes).sha(this.sha).isBinary(this.isBinary);
    }

    public Type getType() {
        return this.type;
    }

    public Long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public String getSha() {
        return this.sha;
    }

    public Boolean getIsBinary() {
        return this.isBinary;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RepositoryObject)) {
            return false;
        }
        RepositoryObject other = (RepositoryObject)o;
        Long this$sizeInBytes = this.getSizeInBytes();
        Long other$sizeInBytes = other.getSizeInBytes();
        if (this$sizeInBytes == null ? other$sizeInBytes != null : !((Object)this$sizeInBytes).equals(other$sizeInBytes)) {
            return false;
        }
        Boolean this$isBinary = this.getIsBinary();
        Boolean other$isBinary = other.getIsBinary();
        if (this$isBinary == null ? other$isBinary != null : !((Object)this$isBinary).equals(other$isBinary)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$sha = this.getSha();
        String other$sha = other.getSha();
        if (this$sha == null ? other$sha != null : !this$sha.equals(other$sha)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $sizeInBytes = this.getSizeInBytes();
        result = result * 59 + ($sizeInBytes == null ? 43 : ((Object)$sizeInBytes).hashCode());
        Boolean $isBinary = this.getIsBinary();
        result = result * 59 + ($isBinary == null ? 43 : ((Object)$isBinary).hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $sha = this.getSha();
        result = result * 59 + ($sha == null ? 43 : $sha.hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "RepositoryObject(type=" + (Object)((Object)this.getType()) + ", sizeInBytes=" + this.getSizeInBytes() + ", sha=" + this.getSha() + ", isBinary=" + this.getIsBinary() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"type", "sizeInBytes", "sha", "isBinary"})
    @Deprecated
    public RepositoryObject(Type type, Long sizeInBytes, String sha, Boolean isBinary) {
        this.type = type;
        this.sizeInBytes = sizeInBytes;
        this.sha = sha;
        this.isBinary = isBinary;
    }

    public static enum Type {
        Blob("BLOB"),
        Tree("TREE"),
        Commit("COMMIT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="type")
        private Type type;
        @JsonProperty(value="sizeInBytes")
        private Long sizeInBytes;
        @JsonProperty(value="sha")
        private String sha;
        @JsonProperty(value="isBinary")
        private Boolean isBinary;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            this.__explicitlySet__.add("sizeInBytes");
            return this;
        }

        public Builder sha(String sha) {
            this.sha = sha;
            this.__explicitlySet__.add("sha");
            return this;
        }

        public Builder isBinary(Boolean isBinary) {
            this.isBinary = isBinary;
            this.__explicitlySet__.add("isBinary");
            return this;
        }

        public RepositoryObject build() {
            RepositoryObject __instance__ = new RepositoryObject(this.type, this.sizeInBytes, this.sha, this.isBinary);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(RepositoryObject o) {
            Builder copiedBuilder = this.type(o.getType()).sizeInBytes(o.getSizeInBytes()).sha(o.getSha()).isBinary(o.getIsBinary());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "RepositoryObject.Builder(type=" + (Object)((Object)this.type) + ", sizeInBytes=" + this.sizeInBytes + ", sha=" + this.sha + ", isBinary=" + this.isBinary + ")";
        }
    }
}

