/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.artifact;

import java.util.Objects;
import org.apache.maven.index.artifact.VersionUtils;

public class Gav {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String baseVersion;
    private final String classifier;
    private final String extension;
    private final Integer snapshotBuildNumber;
    private final Long snapshotTimeStamp;
    private final String name;
    private final boolean snapshot;
    private final boolean hash;
    private final HashType hashType;
    private final boolean signature;
    private final SignatureType signatureType;

    public Gav(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, null, null, null, null, null, false, null, false, null);
    }

    public Gav(String groupId, String artifactId, String version, String classifier, String extension, Integer snapshotBuildNumber, Long snapshotTimeStamp, String name, boolean hash, HashType hashType, boolean signature, SignatureType signatureType) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.snapshot = VersionUtils.isSnapshot(version);
        if (!this.snapshot) {
            this.baseVersion = null;
        } else if (version.contains("SNAPSHOT")) {
            this.baseVersion = null;
        } else {
            String tempBaseVersion = version.substring(0, version.lastIndexOf(45));
            this.baseVersion = (tempBaseVersion = tempBaseVersion.substring(0, tempBaseVersion.length() - 15)).length() > 0 ? tempBaseVersion + "SNAPSHOT" : "SNAPSHOT";
        }
        this.classifier = classifier;
        this.extension = extension;
        this.snapshotBuildNumber = snapshotBuildNumber;
        this.snapshotTimeStamp = snapshotTimeStamp;
        this.name = name;
        this.hash = hash;
        this.hashType = hashType;
        this.signature = signature;
        this.signatureType = signatureType;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBaseVersion() {
        if (this.baseVersion == null) {
            return this.getVersion();
        }
        return this.baseVersion;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public Integer getSnapshotBuildNumber() {
        return this.snapshotBuildNumber;
    }

    public Long getSnapshotTimeStamp() {
        return this.snapshotTimeStamp;
    }

    public boolean isHash() {
        return this.hash;
    }

    public HashType getHashType() {
        return this.hashType;
    }

    public boolean isSignature() {
        return this.signature;
    }

    public SignatureType getSignatureType() {
        return this.signatureType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Gav gav = (Gav)o;
        return this.snapshot == gav.snapshot && this.hash == gav.hash && this.signature == gav.signature && Objects.equals(this.groupId, gav.groupId) && Objects.equals(this.artifactId, gav.artifactId) && Objects.equals(this.version, gav.version) && Objects.equals(this.baseVersion, gav.baseVersion) && Objects.equals(this.classifier, gav.classifier) && Objects.equals(this.extension, gav.extension) && Objects.equals(this.snapshotBuildNumber, gav.snapshotBuildNumber) && Objects.equals(this.snapshotTimeStamp, gav.snapshotTimeStamp) && Objects.equals(this.name, gav.name) && this.hashType == gav.hashType && this.signatureType == gav.signatureType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.groupId, this.artifactId, this.version, this.baseVersion, this.classifier, this.extension, this.snapshotBuildNumber, this.snapshotTimeStamp, this.name, this.snapshot, this.hash, this.hashType, this.signature, this.signatureType});
    }

    public static enum HashType {
        sha1,
        md5;

    }

    public static enum SignatureType {
        gpg;


        public String toString() {
            if (this == gpg) {
                return "asc";
            }
            return "unknown-signature-type";
        }
    }
}

