/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JDialog;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.ui.customizer.Bundle;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public abstract class BasicCustomizer
implements CustomizerProvider {
    static final String LAST_SELECTED_PANEL = "lastSelectedPanel";
    private final Project project;
    private Dialog dialog;
    private String lastSelectedCategory;
    private String layerPath;

    protected BasicCustomizer(Project project, String path) {
        this.project = project;
        this.layerPath = path;
    }

    abstract void storeProperties() throws IOException;

    abstract Lookup prepareData();

    abstract void dialogCleanup();

    protected Project getProject() {
        return this.project;
    }

    public void showCustomizer() {
        this.showCustomizer(null);
    }

    public void showCustomizer(String preselectedCategory) {
        this.showCustomizer(preselectedCategory, null);
    }

    public void showCustomizer(String preselectedCategory, final String preselectedSubCategory) {
        if (this.dialog != null) {
            this.dialog.setVisible(true);
        } else {
            final String category = preselectedCategory != null ? preselectedCategory : this.lastSelectedCategory;
            final AtomicReference context = new AtomicReference();
            ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    context.set(new ProxyLookup(new Lookup[]{BasicCustomizer.this.prepareData(), Lookups.fixed((Object[])new Object[]{new SubCategoryProvider(category, preselectedSubCategory)})}));
                }
            }, (String)Bundle.PROGRESS_loading_data(), (AtomicBoolean)new AtomicBoolean(), (boolean)false);
            if (context.get() == null) {
                return;
            }
            OptionListener listener = new OptionListener();
            this.dialog = ProjectCustomizer.createCustomizerDialog((String)this.layerPath, (Lookup)((Lookup)context.get()), (String)category, (ActionListener)listener, null);
            this.dialog.addWindowListener(listener);
            this.dialog.setTitle(Bundle.LBL_CustomizerTitle(ProjectUtils.getInformation((Project)this.getProject()).getDisplayName()));
            this.dialog.setVisible(true);
        }
    }

    public final void save() {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    BasicCustomizer.this.storeProperties();
                    ProjectManager.getDefault().saveProject(BasicCustomizer.this.project);
                    return null;
                }
            });
        }
        catch (MutexException e) {
            ErrorManager.getDefault().notify((Throwable)((IOException)e.getException()));
        }
    }

    private String findLastSelectedCategory() {
        if (this.dialog instanceof JDialog) {
            return (String)((JDialog)this.dialog).getRootPane().getClientProperty(LAST_SELECTED_PANEL);
        }
        return null;
    }

    public static final class SubCategoryProvider {
        private String subcategory;
        private String category;

        SubCategoryProvider(String category, String subcategory) {
            this.category = category;
            this.subcategory = subcategory;
        }

        public String getCategory() {
            return this.category;
        }

        public String getSubcategory() {
            return this.subcategory;
        }
    }

    protected class OptionListener
    extends WindowAdapter
    implements ActionListener {
        protected OptionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicCustomizer.this.save();
        }

        @Override
        public void windowClosed(WindowEvent e) {
            this.doClose();
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.doClose();
        }

        public void doClose() {
            if (BasicCustomizer.this.dialog != null) {
                BasicCustomizer.this.lastSelectedCategory = BasicCustomizer.this.findLastSelectedCategory();
                BasicCustomizer.this.dialog.removeWindowListener(this);
                BasicCustomizer.this.dialog.setVisible(false);
                BasicCustomizer.this.dialog.dispose();
                BasicCustomizer.this.dialogCleanup();
            }
            BasicCustomizer.this.dialog = null;
        }
    }
}

