/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phing.ui.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.phing.PhingBuildTool;
import org.netbeans.modules.php.phing.exec.PhingExecutable;
import org.netbeans.modules.php.phing.file.PhingTargets;
import org.netbeans.modules.php.phing.ui.actions.Bundle;
import org.netbeans.modules.php.phing.util.PhingUtils;
import org.netbeans.modules.web.clientproject.api.build.BuildTools;
import org.netbeans.spi.project.ui.support.ProjectConvertors;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.actions.Presenter;

public final class RunPhingTargetAction
extends AbstractAction
implements ContextAwareAction,
Presenter.Popup {
    static final Logger LOGGER = Logger.getLogger(RunPhingTargetAction.class.getName());
    @NullAllowed
    private final Project project;
    @NullAllowed
    private final FileObject buildXml;

    public RunPhingTargetAction() {
        this((Project)null);
    }

    private RunPhingTargetAction(Project project) {
        this(project, null);
    }

    private RunPhingTargetAction(Project project, FileObject buildXml) {
        this.project = project;
        this.buildXml = buildXml;
        this.setEnabled(project != null);
        this.putValue("hideWhenDisabled", true);
        this.putValue("Name", null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        assert (false);
    }

    public Action createContextAwareInstance(Lookup context) {
        DataObject dataObject;
        Project contextProject = (Project)context.lookup(Project.class);
        if (contextProject != null) {
            return this.createAction(contextProject);
        }
        FileObject file = (FileObject)context.lookup(FileObject.class);
        if (file == null && (dataObject = (DataObject)context.lookup(DataObject.class)) != null) {
            file = dataObject.getPrimaryFile();
        }
        if (file == null) {
            return this;
        }
        contextProject = ProjectConvertors.getNonConvertorOwner((FileObject)file);
        if (contextProject == null) {
            return this;
        }
        if (file.getParent().equals(contextProject.getProjectDirectory())) {
            return this.createAction(contextProject);
        }
        return this.createAction(contextProject, file);
    }

    private Action createAction(Project contextProject) {
        return this.createAction(contextProject, null);
    }

    private Action createAction(Project contextProject, @NullAllowed FileObject buildXml) {
        assert (contextProject != null);
        PhingBuildTool phingBuildTool = PhingBuildTool.inProject(contextProject);
        if (phingBuildTool == null) {
            return this;
        }
        if (buildXml != null) {
            return new RunPhingTargetAction(contextProject, buildXml);
        }
        if (!phingBuildTool.getProjectBuildXml().exists()) {
            return this;
        }
        return new RunPhingTargetAction(contextProject);
    }

    public JMenuItem getPopupPresenter() {
        if (this.project == null) {
            return new Actions.MenuItem((Action)this, false);
        }
        return BuildTools.getDefault().createTasksMenu((BuildTools.TasksMenuSupport)new TasksMenuSupportImpl(this.project, this.buildXml));
    }

    private static final class TargetsFuture
    implements Future<List<String>> {
        private final PhingTargets phingTargets;

        public TargetsFuture(PhingTargets phingTargets) {
            assert (phingTargets != null);
            this.phingTargets = phingTargets;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.phingTargets.getTargets() != null;
        }

        @Override
        public List<String> get() throws InterruptedException, ExecutionException {
            try {
                return this.phingTargets.loadTargets(null, null);
            }
            catch (TimeoutException ex) {
                assert (false);
                return null;
            }
        }

        @Override
        public List<String> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.phingTargets.loadTargets(timeout, unit);
        }
    }

    private static final class TasksMenuSupportImpl
    implements BuildTools.TasksMenuSupport {
        private final Project project;
        @NullAllowed
        private final FileObject buildXml;
        private final PhingTargets phingTargets;

        public TasksMenuSupportImpl(Project project, @NullAllowed FileObject buildXml) {
            assert (project != null);
            this.project = project;
            this.buildXml = buildXml;
            this.phingTargets = PhingBuildTool.forProject(project).getPhingTargets(buildXml);
        }

        public Project getProject() {
            return this.project;
        }

        public FileObject getWorkDir() {
            if (this.buildXml == null) {
                return this.project.getProjectDirectory();
            }
            return this.buildXml.getParent();
        }

        public String getIdentifier() {
            return "Phing";
        }

        public String getBuildToolExecName() {
            return "phing";
        }

        public String getTitle(BuildTools.TasksMenuSupport.Title title) {
            switch (title) {
                case MENU: {
                    return Bundle.RunPhingTargetAction_name();
                }
                case LOADING_TASKS: {
                    return Bundle.TasksMenuSupportImpl_targets_loading();
                }
                case CONFIGURE_TOOL: {
                    return Bundle.TasksMenuSupportImpl_phing_configure();
                }
                case MANAGE_ADVANCED: {
                    return Bundle.TasksMenuSupportImpl_targets_manage_advanced();
                }
                case TASKS_LABEL: {
                    return Bundle.TasksMenuSupportImpl_targets_label();
                }
            }
            assert (false) : "Unknown title: " + title;
            return null;
        }

        public String getDefaultTaskName() {
            return "default";
        }

        public Future<List<String>> getTasks() {
            return new TargetsFuture(this.phingTargets);
        }

        public void runTask(String ... args) {
            assert (!EventQueue.isDispatchThread());
            PhingExecutable phing = this.getPhingExecutable();
            if (phing != null) {
                PhingUtils.logUsagePhingBuild();
                phing.run(args);
            }
        }

        public void reloadTasks() {
            assert (!EventQueue.isDispatchThread());
            this.phingTargets.reset();
            try {
                this.phingTargets.loadTargets(null, null);
            }
            catch (ExecutionException | TimeoutException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }

        public void configure() {
            OptionsDisplayer.getDefault().open("org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/FrameworksAndTools/Phing");
        }

        @CheckForNull
        private PhingExecutable getPhingExecutable() {
            if (this.buildXml == null) {
                return PhingExecutable.getDefault(this.project, true);
            }
            return PhingExecutable.getDefault(this.project, FileUtil.toFile((FileObject)this.buildXml).getParentFile(), true);
        }
    }
}

