/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.image;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.image.CustomZoomAction;
import org.netbeans.modules.image.ImageDataObject;
import org.netbeans.modules.image.ImageOpenSupport;
import org.netbeans.modules.image.NBImageIcon;
import org.netbeans.modules.image.ZoomInAction;
import org.netbeans.modules.image.ZoomOutAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;

public class ImageViewer
extends CloneableTopComponent {
    static final long serialVersionUID = 6960127954234034486L;
    private ImageDataObject storedObject;
    private NBImageIcon storedImage;
    private JPanel panel;
    private double scale = 1.0;
    private boolean showGrid = false;
    private final double changeFactor = Math.sqrt(2.0);
    private final Color gridColor = Color.black;
    private PropertyChangeListener nameChangeL;
    private final Collection<JButton> toolbarButtons = new ArrayList<JButton>(11);
    private Component view;
    private static final RequestProcessor RP = new RequestProcessor("Image loader", 1, true);
    private RequestProcessor.Task loadImageTask;
    private int imageHeight = 0;
    private int imageWidth = 0;
    private long imageSize = -1L;
    private final DecimalFormat formatter = new DecimalFormat("#.##");

    public ImageViewer() {
    }

    public ImageViewer(ImageDataObject obj) {
        this.initialize(obj);
    }

    public int getPersistenceType() {
        return 1;
    }

    protected void reloadIcon() {
        this.resizePanel();
        this.panel.repaint();
    }

    private void initialize(ImageDataObject obj) {
        TopComponent.NodeName.connect((TopComponent)this, (Node)obj.getNodeDelegate());
        this.setToolTipText(FileUtil.getFileDisplayName((FileObject)obj.getPrimaryFile()));
        this.storedObject = obj;
        FileObject imageFile = this.storedObject.getPrimaryFile();
        this.imageSize = imageFile.isValid() ? imageFile.getSize() : -1L;
        this.setCloseOperation(0);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImageViewer.class, (String)"ACS_ImageViewer"));
        this.nameChangeL = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("cookie".equals(evt.getPropertyName()) || "name".equals(evt.getPropertyName())) {
                    ImageViewer.this.updateNameInEDT();
                }
            }
        };
        obj.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.nameChangeL, (Object)((Object)obj)));
        this.setFocusable(true);
        this.loadImage(this.storedObject);
    }

    private void updateNameInEDT() {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                ImageViewer.this.updateName();
            }
        });
    }

    private Component createImageView() {
        this.panel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(ImageViewer.this.storedImage.getImage(), 0, 0, (int)(ImageViewer.this.getScale() * (double)ImageViewer.this.storedImage.getIconWidth()), (int)(ImageViewer.this.getScale() * (double)ImageViewer.this.storedImage.getIconHeight()), 0, 0, ImageViewer.this.storedImage.getIconWidth(), ImageViewer.this.storedImage.getIconHeight(), this);
                if (ImageViewer.this.showGrid) {
                    int x = (int)(ImageViewer.this.getScale() * (double)ImageViewer.this.storedImage.getIconWidth());
                    int y = (int)(ImageViewer.this.getScale() * (double)ImageViewer.this.storedImage.getIconHeight());
                    double gridDistance = ImageViewer.this.getScale();
                    if (gridDistance < 2.0) {
                        return;
                    }
                    g.setColor(ImageViewer.this.gridColor);
                    double actualDistance = gridDistance;
                    int i = (int)actualDistance;
                    while (i < x) {
                        g.drawLine(i, 0, i, y - 1);
                        i = (int)(actualDistance += gridDistance);
                    }
                    actualDistance = gridDistance;
                    int j = (int)actualDistance;
                    while (j < y) {
                        g.drawLine(0, j, x - 1, j);
                        j = (int)(actualDistance += gridDistance);
                    }
                }
            }
        };
        this.panel.putClientProperty("print.printable", Boolean.TRUE);
        this.panel.putClientProperty("print.name", this.getToolTipText());
        this.storedImage.setImageObserver(this.panel);
        this.panel.setPreferredSize(new Dimension(this.storedImage.getIconWidth(), this.storedImage.getIconHeight()));
        final JScrollPane scrollPane = new JScrollPane(this.panel);
        MouseWheelListener mwl = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                double oldScale = ImageViewer.this.getScale();
                Point visiblePoint = e.getPoint();
                Point markedPoint = new Point((int)(visiblePoint.getX() / oldScale), (int)(visiblePoint.getY() / oldScale));
                int clicks = e.getWheelRotation();
                int clicks_abs = Math.abs(clicks);
                for (int i = 0; i < clicks_abs; ++i) {
                    if (clicks < 0) {
                        ImageViewer.this.zoomIn();
                        continue;
                    }
                    ImageViewer.this.zoomOut();
                }
                double newScale = ImageViewer.this.getScale();
                Point markedPointInRealSpace = new Point((int)(markedPoint.getX() * newScale), (int)(markedPoint.getY() * newScale));
                Rectangle r = scrollPane.getViewport().getViewRect();
                r.setLocation(markedPointInRealSpace);
                r.translate(-r.width / 2, -r.height / 2);
                ImageViewer.this.panel.scrollRectToVisible(r);
            }
        };
        this.panel.addMouseWheelListener(mwl);
        class DragHandler
        implements MouseListener,
        MouseMotionListener {
            Point startDragPos = null;
            Point scrollPaneStartPos = null;

            DragHandler() {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 2) {
                    this.startDragPos = e.getPoint();
                    this.scrollPaneStartPos = scrollPane.getViewport().getViewPosition();
                    ImageViewer.this.panel.setCursor(Cursor.getPredefinedCursor(13));
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 2) {
                    this.startDragPos = null;
                    this.scrollPaneStartPos = null;
                    ImageViewer.this.panel.setCursor(null);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (this.startDragPos != null) {
                    Point newPos = e.getPoint();
                    int delta_x = newPos.x - this.startDragPos.x;
                    int delta_y = newPos.y - this.startDragPos.y;
                    Point scrollPanePos = this.scrollPaneStartPos.getLocation();
                    scrollPanePos.translate(-delta_x, -delta_y);
                    Dimension viewDim = scrollPane.getViewport().getViewRect().getSize();
                    Dimension contentsDim = scrollPane.getViewport().getViewSize();
                    int maxX = contentsDim.width - viewDim.width;
                    int maxY = contentsDim.height - viewDim.height;
                    if (scrollPanePos.x < 0) {
                        scrollPanePos.x = 0;
                    } else if (scrollPanePos.x > maxX) {
                        scrollPanePos.x = maxX;
                    }
                    if (scrollPanePos.y < 0) {
                        scrollPanePos.y = 0;
                    } else if (scrollPanePos.y > maxY) {
                        scrollPanePos.y = maxY;
                    }
                    scrollPane.getViewport().setViewPosition(scrollPanePos);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        }
        DragHandler dh = new DragHandler();
        this.panel.addMouseListener(dh);
        this.panel.addMouseMotionListener(dh);
        return scrollPane;
    }

    private Component createMessagePanel(String msg) {
        JPanel msgPanel = new JPanel(new GridBagLayout());
        msgPanel.add((Component)new JLabel(msg), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 10, 10));
        return msgPanel;
    }

    void updateView(ImageDataObject imageObj) {
        this.loadImage(imageObj);
    }

    private void setToolbarButtonsEnabled(boolean enabled) {
        assert (this.toolbarButtons != null);
        Iterator<JButton> it = this.toolbarButtons.iterator();
        while (it.hasNext()) {
            it.next().setEnabled(enabled);
        }
    }

    private void loadImage(final ImageDataObject imageObj) {
        this.loadImageTask = RP.create(new Runnable(){

            @Override
            public void run() {
                try (ProgressHandle loadImageProgress = ProgressHandle.createHandle((String)NbBundle.getMessage(ImageViewer.class, (String)"LBL_LoadingImage"));){
                    loadImageProgress.start();
                    ImageViewer.this.performLoadImage(imageObj);
                }
            }
        });
        this.loadImageTask.schedule(0);
    }

    protected void componentClosed() {
        this.loadImageTask.cancel();
        super.componentClosed();
    }

    private void performLoadImage(ImageDataObject imageObj) {
        String errMsg;
        NBImageIcon image;
        try {
            image = NBImageIcon.load(imageObj);
            errMsg = image != null ? null : NbBundle.getMessage(ImageViewer.class, (String)"MSG_CouldNotLoad");
        }
        catch (IOException ex) {
            image = null;
            errMsg = NbBundle.getMessage(ImageViewer.class, (String)"MSG_ErrorWhileLoading");
        }
        assert (image == null != (errMsg == null));
        final NBImageIcon fImage = image;
        final String fErrMsg = errMsg;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImageViewer.this.showImage(fImage, fErrMsg);
            }
        });
    }

    private void initToolbar() {
        JToolBar toolbar = this.createToolBar();
        this.setLayout(new BorderLayout());
        this.add(toolbar, "North");
    }

    private void showImage(NBImageIcon image, String errorMessage) {
        boolean isValid;
        boolean wasValid = this.storedImage != null;
        this.storedImage = image;
        boolean bl = isValid = this.storedImage != null;
        if (wasValid && isValid) {
            this.reloadIcon();
            return;
        }
        if (this.view != null) {
            this.remove(this.view);
        }
        if (isValid) {
            this.view = this.createImageView();
            this.imageWidth = this.storedImage.getIconWidth();
            this.imageHeight = this.storedImage.getIconHeight();
            this.initToolbar();
        } else {
            this.view = this.createMessagePanel(errorMessage);
        }
        this.add(this.view, "Center");
        if (wasValid != isValid) {
            this.setToolbarButtonsEnabled(isValid);
        }
        this.revalidate();
        this.repaint();
    }

    private JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        toolBar.setFloatable(false);
        toolBar.setName(NbBundle.getBundle(ImageViewer.class).getString("ACSN_Toolbar"));
        toolBar.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ImageViewer.class).getString("ACSD_Toolbar"));
        JButton outButton = new JButton((Action)SystemAction.get(ZoomOutAction.class));
        outButton.setToolTipText(NbBundle.getBundle(ImageViewer.class).getString("LBL_ZoomOut"));
        outButton.setMnemonic(NbBundle.getBundle(ImageViewer.class).getString("ACS_Out_BTN_Mnem").charAt(0));
        outButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ImageViewer.class).getString("ACSD_Out_BTN"));
        outButton.setText("");
        toolBar.add(outButton);
        this.toolbarButtons.add(outButton);
        JButton inButton = new JButton((Action)SystemAction.get(ZoomInAction.class));
        inButton.setToolTipText(NbBundle.getBundle(ImageViewer.class).getString("LBL_ZoomIn"));
        inButton.setMnemonic(NbBundle.getBundle(ImageViewer.class).getString("ACS_In_BTN_Mnem").charAt(0));
        inButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ImageViewer.class).getString("ACSD_In_BTN"));
        inButton.setText("");
        toolBar.add(inButton);
        this.toolbarButtons.add(inButton);
        toolBar.addSeparator(new Dimension(11, 0));
        JButton button = this.getZoomButton(1, 1);
        toolBar.add(button);
        this.toolbarButtons.add(button);
        toolBar.addSeparator(new Dimension(11, 0));
        button = this.getZoomButton(1, 3);
        toolBar.add(button);
        this.toolbarButtons.add(button);
        button = this.getZoomButton(1, 5);
        toolBar.add(button);
        this.toolbarButtons.add(button);
        button = this.getZoomButton(1, 7);
        toolBar.add(button);
        this.toolbarButtons.add(button);
        toolBar.addSeparator(new Dimension(11, 0));
        button = this.getZoomButton(3, 1);
        toolBar.add(button);
        this.toolbarButtons.add(button);
        button = this.getZoomButton(5, 1);
        toolBar.add(button);
        this.toolbarButtons.add(button);
        button = this.getZoomButton(7, 1);
        toolBar.add(button);
        this.toolbarButtons.add(button);
        toolBar.addSeparator(new Dimension(11, 0));
        button = this.getZoomButton();
        toolBar.add(button);
        this.toolbarButtons.add(button);
        toolBar.addSeparator(new Dimension(11, 0));
        button = this.getGridButton();
        toolBar.add(button);
        this.toolbarButtons.add(button);
        toolBar.addSeparator(new Dimension(11, 0));
        toolBar.add(new JLabel(NbBundle.getMessage(ImageViewer.class, (String)"LBL_ImageDimensions", (Object)this.imageWidth, (Object)this.imageHeight)));
        if (this.imageSize != -1L) {
            String label;
            double size;
            toolBar.addSeparator(new Dimension(11, 0));
            double kb = 1024.0;
            double mb = kb * kb;
            if ((double)this.imageSize >= mb) {
                size = (double)this.imageSize / mb;
                label = "LBL_ImageSizeMb";
            } else if ((double)this.imageSize >= kb) {
                size = (double)this.imageSize / kb;
                label = "LBL_ImageSizeKb";
            } else {
                size = this.imageSize;
                label = "LBL_ImageSizeBytes";
            }
            toolBar.add(new JLabel(NbBundle.getMessage(ImageViewer.class, (String)label, (Object)this.formatter.format(size))));
        }
        Iterator<JButton> it = this.toolbarButtons.iterator();
        while (it.hasNext()) {
            it.next().setFocusable(false);
        }
        return toolBar;
    }

    private void updateName() {
        String name = this.storedObject.getNodeDelegate().getDisplayName();
        this.setName(name);
        FileObject fo = this.storedObject.getPrimaryFile();
        this.setToolTipText(FileUtil.getFileDisplayName((FileObject)fo));
    }

    public void open() {
        if (this.discard()) {
            return;
        }
        super.open();
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private boolean discard() {
        return this.storedObject == null;
    }

    protected boolean closeLast() {
        ((ImageOpenSupport)this.storedObject.getCookie(ImageOpenSupport.class)).lastClosed();
        return true;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject((Object)this.storedObject);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.storedObject = (ImageDataObject)((Object)in.readObject());
        ((ImageOpenSupport)this.storedObject.getCookie(ImageOpenSupport.class)).prepareViewer();
        this.initialize(this.storedObject);
    }

    protected CloneableTopComponent createClonedObject() {
        return new ImageViewer(this.storedObject);
    }

    public SystemAction[] getSystemActions() {
        SystemAction[] oldValue = super.getSystemActions();
        SystemAction fsa = null;
        try {
            ClassLoader l = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (l == null) {
                l = ((Object)((Object)this)).getClass().getClassLoader();
            }
            Class<SystemAction> c = Class.forName("org.openide.actions.FileSystemAction", true, l).asSubclass(SystemAction.class);
            fsa = (SystemAction)SystemAction.findObject(c, (boolean)true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return SystemAction.linkActions((SystemAction[])new SystemAction[]{SystemAction.get(ZoomInAction.class), SystemAction.get(ZoomOutAction.class), SystemAction.get(CustomZoomAction.class), fsa, null}, (SystemAction[])oldValue);
    }

    public Image getIcon() {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/image/imageObject.png");
    }

    public void zoomIn() {
        this.scaleIn();
        this.resizePanel();
        this.panel.repaint(0, 0, this.panel.getWidth(), this.panel.getHeight());
    }

    public void zoomOut() {
        double oldScale = this.scale;
        this.scaleOut();
        if (!this.isNewSizeOK()) {
            this.scale = oldScale;
            return;
        }
        this.resizePanel();
        this.panel.repaint(0, 0, this.panel.getWidth(), this.panel.getHeight());
    }

    private void resizePanel() {
        this.panel.setPreferredSize(new Dimension((int)(this.getScale() * (double)this.storedImage.getIconWidth()), (int)(this.getScale() * (double)this.storedImage.getIconHeight())));
        this.panel.revalidate();
    }

    private boolean isNewSizeOK() {
        return this.getScale() * (double)this.storedImage.getIconWidth() > 1.0 && this.getScale() * (double)this.storedImage.getIconWidth() > 1.0;
    }

    public void customZoom(int fx, int fy) {
        double oldScale = this.scale;
        this.scale = (double)fx / (double)fy;
        if (!this.isNewSizeOK()) {
            this.scale = oldScale;
            return;
        }
        this.resizePanel();
        this.panel.repaint(0, 0, this.panel.getWidth(), this.panel.getHeight());
    }

    private double getScale() {
        return this.scale;
    }

    private void scaleOut() {
        this.scale /= this.changeFactor;
    }

    private void scaleIn() {
        double oldComputedScale = this.getScale();
        this.scale = this.changeFactor * this.scale;
        double newComputedScale = this.getScale();
        if (newComputedScale == oldComputedScale) {
            this.scale = newComputedScale + 1.0;
        }
    }

    private JButton getZoomButton(final int xf, final int yf) {
        JButton button = new JButton("" + xf + ":" + yf);
        if (xf < yf) {
            button.setToolTipText(NbBundle.getBundle(ImageViewer.class).getString("LBL_ZoomOut") + " " + xf + " : " + yf);
        } else {
            button.setToolTipText(NbBundle.getBundle(ImageViewer.class).getString("LBL_ZoomIn") + " " + xf + " : " + yf);
        }
        button.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ImageViewer.class).getString("ACS_Zoom_BTN"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageViewer.this.customZoom(xf, yf);
            }
        });
        return button;
    }

    private JButton getZoomButton() {
        JButton button = new JButton(NbBundle.getBundle(CustomZoomAction.class).getString("LBL_XtoY"));
        button.setToolTipText(NbBundle.getBundle(ImageViewer.class).getString("LBL_CustomZoom"));
        button.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ImageViewer.class).getString("ACS_Zoom_BTN"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomZoomAction sa = (CustomZoomAction)SystemAction.get(CustomZoomAction.class);
                sa.performAction();
            }
        });
        return button;
    }

    private JButton getGridButton() {
        JButton button = new JButton(" # ");
        button.setToolTipText(NbBundle.getBundle(ImageViewer.class).getString("LBL_ShowHideGrid"));
        button.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ImageViewer.class).getString("ACS_Grid_BTN"));
        button.setMnemonic(NbBundle.getBundle(ImageViewer.class).getString("ACS_Grid_BTN_Mnem").charAt(0));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageViewer.this.showGrid = !ImageViewer.this.showGrid;
                ImageViewer.this.panel.repaint(0, 0, ImageViewer.this.panel.getWidth(), ImageViewer.this.panel.getHeight());
            }
        });
        return button;
    }
}

