/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.server.Monitors;
import org.netbeans.lib.profiler.server.ProfilerRuntimeCPU;
import org.netbeans.lib.profiler.server.ProfilerRuntimeCPUCodeRegion;
import org.netbeans.lib.profiler.server.ProfilerRuntimeMemory;
import org.netbeans.lib.profiler.server.ProfilerRuntimeSampler;
import org.netbeans.lib.profiler.server.ProfilerServer;
import org.netbeans.lib.profiler.server.ProfilingPointServerHandler;
import org.netbeans.lib.profiler.server.ThreadInfo;
import org.netbeans.lib.profiler.server.system.Classes;
import org.netbeans.lib.profiler.server.system.Histogram;
import org.netbeans.lib.profiler.server.system.Timers;

public class ProfilerRuntime
implements CommonConstants {
    private static final boolean DEBUG = false;
    protected static ExternalActionsHandler externalActionsHandler;
    protected static boolean lockContentionMonitoringEnabled;
    protected static byte[] eventBuffer;
    protected static int globalEvBufPos;
    protected static int globalEvBufPosThreshold;
    protected static volatile boolean sendingBuffer;
    private static boolean printEvents;
    private static volatile Set knownMonitors;

    public static void createEventBuffer(int bufSize) {
        eventBuffer = new byte[bufSize];
        globalEvBufPosThreshold = bufSize - 51 - 1;
        globalEvBufPos = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpEventBuffer() {
        if (eventBuffer == null) {
            return;
        }
        if (sendingBuffer) {
            return;
        }
        byte[] byArray = eventBuffer;
        synchronized (eventBuffer) {
            sendingBuffer = true;
            ThreadInfo[] tis = ThreadInfo.getThreadInfos();
            for (int i = 0; i < tis.length; ++i) {
                ThreadInfo ti = tis[i];
                if (ti == null || ti.evBuf == null || !ti.isInitialized()) continue;
                int curPos = ti.evBufPos;
                if (globalEvBufPos + curPos - ti.evBufDumpLastPos > globalEvBufPosThreshold) break;
                int evBufSize = curPos - ti.evBufDumpLastPos;
                if (evBufSize <= 0) continue;
                ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = 13;
                ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(ti.threadId >> 8 & 0xFF);
                ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(ti.threadId & 0xFF);
                System.arraycopy(ti.evBuf, ti.evBufDumpLastPos, eventBuffer, globalEvBufPos, evBufSize);
                globalEvBufPos += evBufSize;
                ti.evBufDumpLastPos = curPos;
            }
            externalActionsHandler.handleEventBufferDump(eventBuffer, 0, globalEvBufPos);
            globalEvBufPos = 0;
            sendingBuffer = false;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected static void copyLocalBuffer(ThreadInfo ti) {
        byte[] byArray;
        long absTimeStamp = 0L;
        long threadTimeStamp = 0L;
        if (eventBuffer == null) {
            return;
        }
        boolean needToAdjustTime = false;
        if (sendingBuffer) {
            absTimeStamp = Timers.getCurrentTimeInCounts();
            if (ProfilerRuntimeCPU.threadCPUTimerOn) {
                threadTimeStamp = Timers.getThreadCPUTimeInNanos();
            }
            byArray = eventBuffer;
            // MONITORENTER : eventBuffer
            if (sendingBuffer) {
                System.err.println("*** Sanity check failed - sendingBuffer where should have been already sent");
            }
            needToAdjustTime = true;
            // MONITOREXIT : byArray
        }
        byArray = eventBuffer;
        // MONITORENTER : eventBuffer
        if (!ti.isInitialized()) {
            // MONITOREXIT : byArray
            return;
        }
        int curPos = ti.evBufPos;
        int evBufDumpLastPos = ti.evBufDumpLastPos;
        if (globalEvBufPos + curPos - evBufDumpLastPos > globalEvBufPosThreshold) {
            sendingBuffer = true;
            if (!needToAdjustTime) {
                absTimeStamp = Timers.getCurrentTimeInCounts();
                if (ProfilerRuntimeCPU.threadCPUTimerOn) {
                    threadTimeStamp = Timers.getThreadCPUTimeInNanos();
                }
                needToAdjustTime = true;
            }
            externalActionsHandler.handleEventBufferDump(eventBuffer, 0, globalEvBufPos);
            globalEvBufPos = 0;
            sendingBuffer = false;
        }
        if (eventBuffer != null) {
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = 13;
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(ti.threadId >> 8 & 0xFF);
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(ti.threadId & 0xFF);
            System.arraycopy(ti.evBuf, evBufDumpLastPos, eventBuffer, globalEvBufPos, curPos - evBufDumpLastPos);
            globalEvBufPos += curPos - evBufDumpLastPos;
            ti.evBufPos = 0;
            ti.evBufDumpLastPos = 0;
            if (needToAdjustTime) {
                ProfilerRuntime.writeAdjustTimeEvent(ti, absTimeStamp, threadTimeStamp);
            }
        }
        // MONITOREXIT : byArray
    }

    public static void init(ExternalActionsHandler h) {
        externalActionsHandler = h;
    }

    public static void setLockContentionMonitoringEnabled(boolean b) {
        lockContentionMonitoringEnabled = b;
        knownMonitors = b ? new HashSet() : null;
        Classes.setLockContentionMonitoringEnabled((boolean)b);
    }

    public static void monitorEntry(Thread t, Object monitor, Thread owner) {
        ThreadInfo ownerTi;
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isProfilerServerThread(t) || ThreadInfo.isProfilerServerMonitor(monitor)) {
            return;
        }
        long timeStamp = -1L;
        ThreadInfo ti = ThreadInfo.getThreadInfo(t);
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        ProfilingSessionStatus status = ProfilerServer.getProfilingSessionStatus();
        ThreadInfo threadInfo = ownerTi = owner != null ? ThreadInfo.getThreadInfo(owner) : null;
        if (status != null) {
            switch (status.currentInstrType) {
                case 3: 
                case 4: {
                    timeStamp = ProfilerRuntimeCPU.monitorEntryCPU(ti, monitor, ownerTi);
                    break;
                }
                case 1: {
                    timeStamp = ProfilerRuntimeCPUCodeRegion.monitorEntryRegion(t, monitor, ownerTi);
                }
            }
        }
        if (lockContentionMonitoringEnabled && timeStamp == -1L) {
            ProfilerRuntime.writeWaitTimeEvent((byte)22, ti, monitor, ownerTi);
        }
        Monitors.recordThreadStateChange(ti.thread, (byte)3, timeStamp, monitor);
        --ti.inProfilingRuntimeMethod;
    }

    public static void monitorExit(Thread t, Object monitor) {
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isProfilerServerThread(t) || ThreadInfo.isProfilerServerMonitor(monitor)) {
            return;
        }
        long timeStamp = -1L;
        ThreadInfo ti = ThreadInfo.getThreadInfo(t);
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        ProfilingSessionStatus status = ProfilerServer.getProfilingSessionStatus();
        if (status != null) {
            switch (status.currentInstrType) {
                case 3: 
                case 4: {
                    timeStamp = ProfilerRuntimeCPU.monitorExitCPU(ti, monitor);
                    break;
                }
                case 1: {
                    timeStamp = ProfilerRuntimeCPUCodeRegion.monitorExitRegion(t, monitor);
                }
            }
        }
        if (lockContentionMonitoringEnabled && timeStamp == -1L) {
            ProfilerRuntime.writeWaitTimeEvent((byte)23, ti, monitor);
        }
        Monitors.recordThreadStateChange(ti.thread, (byte)1, timeStamp, null);
        --ti.inProfilingRuntimeMethod;
    }

    public static void sleepEntry() {
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isCurrentThreadProfilerServerThread()) {
            return;
        }
        long timeStamp = -1L;
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        ProfilingSessionStatus status = ProfilerServer.getProfilingSessionStatus();
        if (status != null) {
            switch (status.currentInstrType) {
                case 3: 
                case 4: {
                    timeStamp = ProfilerRuntimeCPU.sleepEntryCPU(ti);
                    break;
                }
                case 1: {
                    ProfilerRuntimeCPUCodeRegion.sleepEntryRegion();
                }
            }
        }
        Monitors.recordThreadStateChange(ti.thread, (byte)2, timeStamp, null);
        --ti.inProfilingRuntimeMethod;
    }

    public static void sleepExit() {
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isCurrentThreadProfilerServerThread()) {
            return;
        }
        long timeStamp = -1L;
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        ProfilingSessionStatus status = ProfilerServer.getProfilingSessionStatus();
        if (status != null) {
            switch (status.currentInstrType) {
                case 3: 
                case 4: {
                    timeStamp = ProfilerRuntimeCPU.sleepExitCPU(ti);
                    break;
                }
                case 1: {
                    ProfilerRuntimeCPUCodeRegion.sleepExitRegion();
                }
            }
        }
        Monitors.recordThreadStateChange(ti.thread, (byte)1, timeStamp, null);
        --ti.inProfilingRuntimeMethod;
    }

    public static void waitEntry() {
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isCurrentThreadProfilerServerThread()) {
            return;
        }
        long timeStamp = -1L;
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        ProfilingSessionStatus status = ProfilerServer.getProfilingSessionStatus();
        if (status != null) {
            switch (status.currentInstrType) {
                case 3: 
                case 4: {
                    timeStamp = ProfilerRuntimeCPU.waitEntryCPU(ti);
                    break;
                }
                case 1: {
                    ProfilerRuntimeCPUCodeRegion.waitEntryRegion();
                }
            }
        }
        Monitors.recordThreadStateChange(ti.thread, (byte)4, timeStamp, null);
        --ti.inProfilingRuntimeMethod;
    }

    public static void waitExit() {
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isCurrentThreadProfilerServerThread()) {
            return;
        }
        long timeStamp = -1L;
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        ProfilingSessionStatus status = ProfilerServer.getProfilingSessionStatus();
        if (status != null) {
            switch (status.currentInstrType) {
                case 3: 
                case 4: {
                    timeStamp = ProfilerRuntimeCPU.waitExitCPU(ti);
                    break;
                }
                case 1: {
                    ProfilerRuntimeCPUCodeRegion.waitExitRegion();
                }
            }
        }
        Monitors.recordThreadStateChange(ti.thread, (byte)1, timeStamp, null);
        --ti.inProfilingRuntimeMethod;
    }

    public static void parkEntry() {
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isCurrentThreadProfilerServerThread()) {
            return;
        }
        long timeStamp = -1L;
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        ProfilingSessionStatus status = ProfilerServer.getProfilingSessionStatus();
        if (status != null) {
            switch (status.currentInstrType) {
                case 3: 
                case 4: {
                    timeStamp = ProfilerRuntimeCPU.parkEntryCPU(ti);
                    break;
                }
                case 1: {
                    ProfilerRuntimeCPUCodeRegion.parkEntryRegion();
                }
            }
        }
        Monitors.recordThreadStateChange(ti.thread, (byte)5, timeStamp, null);
        --ti.inProfilingRuntimeMethod;
    }

    public static void parkExit() {
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isCurrentThreadProfilerServerThread()) {
            return;
        }
        long timeStamp = -1L;
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        ProfilingSessionStatus status = ProfilerServer.getProfilingSessionStatus();
        if (status != null) {
            switch (status.currentInstrType) {
                case 3: 
                case 4: {
                    timeStamp = ProfilerRuntimeCPU.parkExitCPU(ti);
                    break;
                }
                case 1: {
                    ProfilerRuntimeCPUCodeRegion.parkExitRegion();
                }
            }
        }
        Monitors.recordThreadStateChange(ti.thread, (byte)1, timeStamp, null);
        --ti.inProfilingRuntimeMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetProfilerCollectors(int instrType) {
        if (instrType != 1 && eventBuffer != null) {
            byte[] byArray = eventBuffer;
            synchronized (eventBuffer) {
                ProfilerRuntime.doResetProfilerCollectors(instrType);
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        } else {
            ProfilerRuntime.doResetProfilerCollectors(instrType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeProfilingPointHitEvent(int id, long absTimeStamp) {
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        int tid = ti.threadId;
        if (ti.evBuf == null || !ti.isInitialized()) {
            byte[] byArray = eventBuffer;
            synchronized (eventBuffer) {
                int curPos = globalEvBufPos;
                if (curPos > globalEvBufPosThreshold) {
                    ProfilerRuntime.dumpEventBuffer();
                    curPos = 0;
                }
                globalEvBufPos = curPos = ProfilerRuntime.writePPointHitToBuffer(eventBuffer, absTimeStamp, curPos, id, tid);
                // ** MonitorExit[var5_4] (shouldn't be in output)
            }
        } else {
            int curPos = ti.evBufPos;
            if (curPos > ThreadInfo.evBufPosThreshold) {
                ProfilerRuntimeCPU.copyLocalBuffer(ti);
                curPos = ti.evBufPos;
            }
            byte[] evBuf = ti.evBuf;
            ti.evBufPos = ProfilerRuntime.writePPointHitToBuffer(evBuf, absTimeStamp, curPos, id, tid);
        }
    }

    public static void profilePointHit(char id) {
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isCurrentThreadProfilerServerThread()) {
            return;
        }
        if (eventBuffer == null) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        ProfilingPointServerHandler method = ProfilingPointServerHandler.getHandler(id);
        if (method != null) {
            try {
                method.profilingPointHit(id);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        --ti.inProfilingRuntimeMethod;
    }

    static void writeThreadCreationEvent(ThreadInfo ti) {
        ProfilerRuntime.writeThreadCreationEvent(ti.thread, ti.getThreadId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeThreadCreationEvent(Thread thread, int threadId) {
        String threadName;
        String threadClassName = thread.getClass().getName();
        try {
            threadName = thread.getName();
        }
        catch (NullPointerException e) {
            threadName = "*Unknown thread (" + threadId + ")*";
        }
        int fullInfoLen = (threadName.length() + threadClassName.length()) * 2 + 7;
        byte[] byArray = eventBuffer;
        synchronized (eventBuffer) {
            if (globalEvBufPos + fullInfoLen > globalEvBufPosThreshold) {
                sendingBuffer = true;
                externalActionsHandler.handleEventBufferDump(eventBuffer, 0, globalEvBufPos);
                globalEvBufPos = 0;
                sendingBuffer = false;
            }
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = 11;
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(threadId >> 8 & 0xFF);
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(threadId & 0xFF);
            byte[] name = threadName.getBytes();
            int len = name.length;
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(len >> 8 & 0xFF);
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(len & 0xFF);
            System.arraycopy(name, 0, eventBuffer, globalEvBufPos, len);
            globalEvBufPos += len;
            name = threadClassName.getBytes();
            len = name.length;
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(len >> 8 & 0xFF);
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(len & 0xFF);
            System.arraycopy(name, 0, eventBuffer, globalEvBufPos, len);
            globalEvBufPos += len;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static void writeAdjustTimeEvent(ThreadInfo ti, long absTimeStamp, long threadTimeStamp) {
        byte[] evBuf = ti.evBuf;
        int curPos = ti.evBufPos;
        if (curPos > ThreadInfo.evBufPosThreshold) {
            if (eventBuffer == null) {
                return;
            }
            byte[] byArray = eventBuffer;
            // MONITORENTER : eventBuffer
            curPos = ti.evBufPos;
            boolean globalBufNeedsDump = false;
            int evBufDumpLastPos = ti.evBufDumpLastPos;
            if (globalEvBufPos + curPos - evBufDumpLastPos > globalEvBufPosThreshold) {
                globalBufNeedsDump = true;
                sendingBuffer = true;
                externalActionsHandler.handleEventBufferDump(eventBuffer, 0, globalEvBufPos);
                globalEvBufPos = 0;
                sendingBuffer = false;
            }
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = 13;
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(ti.threadId >> 8 & 0xFF);
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(ti.threadId & 0xFF);
            System.arraycopy(evBuf, evBufDumpLastPos, eventBuffer, globalEvBufPos, curPos - evBufDumpLastPos);
            globalEvBufPos += curPos - evBufDumpLastPos;
            ti.evBufPos = 0;
            ti.evBufDumpLastPos = 0;
            // MONITOREXIT : byArray
        }
        curPos = ti.evBufPos;
        evBuf[curPos++] = 5;
        long absInterval = Timers.getCurrentTimeInCounts() - absTimeStamp;
        evBuf[curPos++] = (byte)(absInterval >> 48 & 0xFFL);
        evBuf[curPos++] = (byte)(absInterval >> 40 & 0xFFL);
        evBuf[curPos++] = (byte)(absInterval >> 32 & 0xFFL);
        evBuf[curPos++] = (byte)(absInterval >> 24 & 0xFFL);
        evBuf[curPos++] = (byte)(absInterval >> 16 & 0xFFL);
        evBuf[curPos++] = (byte)(absInterval >> 8 & 0xFFL);
        evBuf[curPos++] = (byte)(absInterval & 0xFFL);
        if (ProfilerRuntimeCPU.threadCPUTimerOn) {
            long threadInterval = Timers.getThreadCPUTimeInNanos() - threadTimeStamp;
            evBuf[curPos++] = (byte)(threadInterval >> 48 & 0xFFL);
            evBuf[curPos++] = (byte)(threadInterval >> 40 & 0xFFL);
            evBuf[curPos++] = (byte)(threadInterval >> 32 & 0xFFL);
            evBuf[curPos++] = (byte)(threadInterval >> 24 & 0xFFL);
            evBuf[curPos++] = (byte)(threadInterval >> 16 & 0xFFL);
            evBuf[curPos++] = (byte)(threadInterval >> 8 & 0xFFL);
            evBuf[curPos++] = (byte)(threadInterval & 0xFFL);
        }
        ti.evBufPos = curPos;
    }

    static long writeWaitTimeEvent(byte eventType, ThreadInfo ti, Object id) {
        return ProfilerRuntime.writeWaitTimeEvent(eventType, ti, id, null);
    }

    static long writeWaitTimeEvent(byte eventType, ThreadInfo ti, Object id, ThreadInfo ownerTi) {
        int curPos;
        if (eventBuffer == null) {
            return -1L;
        }
        int hash = ProfilerRuntime.writeNewMonitorEvent(ti, id);
        if (ownerTi != null) {
            ProfilerRuntime.initThreadInfo(ownerTi);
        }
        if ((curPos = ti.evBufPos) > ThreadInfo.evBufPosThreshold) {
            ProfilerRuntime.copyLocalBuffer(ti);
            curPos = ti.evBufPos;
        }
        byte[] evBuf = ti.evBuf;
        evBuf[curPos++] = eventType;
        long absTimeStamp = Timers.getCurrentTimeInCounts();
        evBuf[curPos++] = (byte)(absTimeStamp >> 48 & 0xFFL);
        evBuf[curPos++] = (byte)(absTimeStamp >> 40 & 0xFFL);
        evBuf[curPos++] = (byte)(absTimeStamp >> 32 & 0xFFL);
        evBuf[curPos++] = (byte)(absTimeStamp >> 24 & 0xFFL);
        evBuf[curPos++] = (byte)(absTimeStamp >> 16 & 0xFFL);
        evBuf[curPos++] = (byte)(absTimeStamp >> 8 & 0xFFL);
        evBuf[curPos++] = (byte)(absTimeStamp & 0xFFL);
        if (hash != -1) {
            evBuf[curPos++] = (byte)(hash >> 24 & 0xFF);
            evBuf[curPos++] = (byte)(hash >> 16 & 0xFF);
            evBuf[curPos++] = (byte)(hash >> 8 & 0xFF);
            evBuf[curPos++] = (byte)(hash & 0xFF);
            if (eventType == 22) {
                int ownerId = -1;
                if (ownerTi != null) {
                    ownerId = ownerTi.getThreadId();
                }
                evBuf[curPos++] = (byte)(ownerId >> 24 & 0xFF);
                evBuf[curPos++] = (byte)(ownerId >> 16 & 0xFF);
                evBuf[curPos++] = (byte)(ownerId >> 8 & 0xFF);
                evBuf[curPos++] = (byte)(ownerId & 0xFF);
            }
        }
        ti.evBufPos = curPos;
        return absTimeStamp;
    }

    private static int writeNewMonitorEvent(ThreadInfo ti, Object id) {
        if (id == null || !lockContentionMonitoringEnabled) {
            return -1;
        }
        ProfilerRuntime.initThreadInfo(ti);
        int hash = System.identityHashCode(id);
        Integer hashInt = new Integer(hash);
        if (knownMonitors.add(hashInt)) {
            int curPos = ti.evBufPos;
            if (curPos > ThreadInfo.evBufPosThreshold) {
                ProfilerRuntime.copyLocalBuffer(ti);
                curPos = ti.evBufPos;
            }
            byte[] evBuf = ti.evBuf;
            evBuf[curPos++] = 28;
            evBuf[curPos++] = (byte)(hash >> 24 & 0xFF);
            evBuf[curPos++] = (byte)(hash >> 16 & 0xFF);
            evBuf[curPos++] = (byte)(hash >> 8 & 0xFF);
            evBuf[curPos++] = (byte)(hash & 0xFF);
            byte[] name = id.getClass().getName().getBytes();
            int len = name.length;
            evBuf[curPos++] = (byte)(len >> 8 & 0xFF);
            evBuf[curPos++] = (byte)(len & 0xFF);
            System.arraycopy(name, 0, evBuf, curPos, len);
            ti.evBufPos = curPos += len;
        }
        return hash;
    }

    private static void initThreadInfo(ThreadInfo ti) {
        if (!ti.isInitialized()) {
            ti.initialize();
            ti.useEventBuffer();
            ProfilerRuntime.writeThreadCreationEvent(ti);
        } else if (ti.evBuf == null) {
            ti.useEventBuffer();
        }
    }

    public static boolean profiledTargetAppThreadsExist() {
        return ThreadInfo.getNProfiledAppThreads() > 0;
    }

    protected static void changeAllThreadsInProfRuntimeMethodStatus(int val) {
        ThreadInfo.changeAllThreadsInProfRuntimeMethodStatus(val);
    }

    protected static void clearDataStructures() {
        eventBuffer = null;
        globalEvBufPos = 0;
        ThreadInfo.resetThreadInfoTable();
        knownMonitors = new HashSet();
    }

    protected static void createNewDataStructures() {
        ThreadInfo.resetThreadInfoTable();
    }

    private static void doResetProfilerCollectors(int instrType) {
        ThreadInfo.resetThreadInfoTable();
        globalEvBufPos = 0;
        knownMonitors = new HashSet();
        if (eventBuffer != null) {
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = 10;
        }
        switch (instrType) {
            case 3: 
            case 4: {
                ProfilerRuntimeCPU.resetProfilerCollectors();
                break;
            }
            case 2: {
                ProfilerRuntimeSampler.resetProfilerCollectors();
                break;
            }
            case 1: {
                ProfilerRuntimeCPUCodeRegion.resetProfilerCollectors();
                break;
            }
            case 5: 
            case 6: {
                ProfilerRuntimeMemory.resetProfilerCollectors(instrType);
                break;
            }
            case 7: {
                if (!Histogram.isAvailable()) break;
                ProfilerServer.notifyClientOnResultsAvailability();
            }
        }
    }

    private static int writePPointHitToBuffer(byte[] buf, long absTimeStamp, int curPos, int id, int tid) {
        buf[curPos++] = 29;
        buf[curPos++] = (byte)(id >> 8 & 0xFF);
        buf[curPos++] = (byte)(id & 0xFF);
        buf[curPos++] = (byte)(absTimeStamp >> 48 & 0xFFL);
        buf[curPos++] = (byte)(absTimeStamp >> 40 & 0xFFL);
        buf[curPos++] = (byte)(absTimeStamp >> 32 & 0xFFL);
        buf[curPos++] = (byte)(absTimeStamp >> 24 & 0xFFL);
        buf[curPos++] = (byte)(absTimeStamp >> 16 & 0xFFL);
        buf[curPos++] = (byte)(absTimeStamp >> 8 & 0xFFL);
        buf[curPos++] = (byte)(absTimeStamp & 0xFFL);
        buf[curPos++] = (byte)(tid >> 8 & 0xFF);
        buf[curPos++] = (byte)(tid & 0xFF);
        return curPos;
    }

    public static interface ExternalActionsHandler {
        public void handleEventBufferDump(byte[] var1, int var2, int var3);

        public void handleFirstTimeMethodInvoke(char var1);

        public int handleFirstTimeVMObjectAlloc(String var1, int var2);

        public void handleReflectiveInvoke(Method var1);
    }
}

