/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.request;

import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Container;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.ServletWrapper;
import org.apache.tomcat.core.TomcatException;

public class InvokerInterceptor
extends BaseInterceptor {
    String prefix = "/servlet/";
    int prefixLen = this.prefix.length();

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        this.prefixLen = prefix.length();
    }

    public int requestMap(Request req) {
        int secondSlash;
        Container ct = req.getContainer();
        if (req.getWrapper() != null && ct != null && ct.getMapType() != 4) {
            return 0;
        }
        String pathInfo = req.getPathInfo();
        String servletPath = req.getServletPath();
        if (servletPath == null || !servletPath.startsWith(this.prefix)) {
            return 0;
        }
        Context ctx = req.getContext();
        String servletName = null;
        String newPathInfo = null;
        if (this.debug > 0) {
            this.log("Original ServletPath=" + servletPath + " PathInfo=" + pathInfo);
        }
        if ((secondSlash = servletPath.indexOf("/", this.prefixLen)) > -1) {
            servletName = servletPath.substring(this.prefixLen, secondSlash);
            newPathInfo = servletPath.substring(secondSlash);
        } else {
            servletName = servletPath.substring(this.prefixLen);
        }
        String newServletPath = this.prefix + servletName;
        if (this.debug > 0) {
            this.log("After pathfix SN=" + servletName + " SP=" + newServletPath + " PI=" + newPathInfo);
        }
        ServletWrapper wrapper = ctx.getServletByName(servletName);
        req.setServletPath(newServletPath);
        req.setPathInfo(newPathInfo);
        if (wrapper != null) {
            req.setWrapper(wrapper);
            return 0;
        }
        try {
            wrapper = ctx.addServlet(servletName, servletName);
            ctx.addServletMapping(newServletPath + "/*", servletName);
            wrapper.setOrigin(1);
            if (this.debug > 0) {
                this.log("Added mapping " + wrapper + " path=" + newServletPath + "/*");
            }
        }
        catch (TomcatException ex) {
            ex.printStackTrace();
            return 404;
        }
        req.setWrapper(wrapper);
        return 0;
    }
}

