/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.jgit.transport.Transport;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitPushResult;
import org.netbeans.libs.git.GitTransportUpdate;
import org.netbeans.libs.git.jgit.DelegatingProgressMonitor;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.TransportCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class PushCommand
extends TransportCommand {
    private final ProgressMonitor monitor;
    private final List<String> pushRefSpecs;
    private final String remote;
    private GitPushResult result;
    private final List<String> fetchRefSpecs;

    public PushCommand(Repository repository, GitClassFactory gitFactory, String remote, List<String> pushRefSpecifications, List<String> fetchRefSpecifications, ProgressMonitor monitor) {
        super(repository, gitFactory, remote, monitor);
        this.monitor = monitor;
        this.remote = remote;
        this.pushRefSpecs = pushRefSpecifications;
        this.fetchRefSpecs = fetchRefSpecifications;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void runTransportCommand() throws GitException.AuthorizationException, GitException {
        Transport transport;
        ArrayList<RefSpec> specs = new ArrayList<RefSpec>(this.pushRefSpecs.size());
        for (String string : this.pushRefSpecs) {
            RefSpec sp = new RefSpec(string);
            String source = sp.getSource();
            String dest = sp.getDestination();
            if (source != null && Transport.REFSPEC_TAGS.matchSource(source) && dest != null && Transport.REFSPEC_TAGS.matchDestination(sp.getDestination())) {
                specs.add(sp);
                continue;
            }
            specs.add(sp.setForceUpdate(false));
        }
        ArrayList<RefSpec> fetchSpecs = new ArrayList<RefSpec>(this.fetchRefSpecs == null ? 0 : this.fetchRefSpecs.size());
        for (String refSpec : this.fetchRefSpecs) {
            RefSpec sp = new RefSpec(refSpec);
            fetchSpecs.add(sp);
        }
        try (Object var3_5 = null;){
            transport = this.openTransport(true);
            transport.setDryRun(false);
            transport.setPushThin(true);
            transport.setRemoveDeletedRefs(true);
            transport.setTagOpt(TagOpt.AUTO_FOLLOW);
            PushResult pushResult = transport.push((org.eclipse.jgit.lib.ProgressMonitor)new DelegatingProgressMonitor(this.monitor), fetchSpecs.isEmpty() ? transport.findRemoteRefUpdatesFor(specs) : Transport.findRemoteRefUpdatesFor((Repository)this.getRepository(), specs, fetchSpecs));
            Map<String, GitBranch> remoteBranches = Utils.refsToBranches(pushResult.getAdvertisedRefs(), "refs/heads/", this.getClassFactory());
            this.processMessages(pushResult.getMessages());
            HashMap<String, GitTransportUpdate> remoteRepositoryUpdates = new HashMap<String, GitTransportUpdate>(pushResult.getRemoteUpdates().size());
            for (RemoteRefUpdate update : pushResult.getRemoteUpdates()) {
                GitTransportUpdate upd = this.getClassFactory().createTransportUpdate(transport.getURI(), update, remoteBranches);
                remoteRepositoryUpdates.put(upd.getRemoteName(), upd);
            }
            HashMap<String, GitTransportUpdate> localRepositoryUpdates = new HashMap<String, GitTransportUpdate>(pushResult.getTrackingRefUpdates().size());
            for (TrackingRefUpdate update : pushResult.getTrackingRefUpdates()) {
                GitTransportUpdate upd = this.getClassFactory().createTransportUpdate(transport.getURI(), update);
                localRepositoryUpdates.put(upd.getRemoteName(), upd);
            }
            this.result = this.getClassFactory().createPushResult(remoteRepositoryUpdates, localRepositoryUpdates);
            if (transport == null) return;
        }
        transport.close();
        return;
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git push ").append(this.remote);
        for (String refSpec : this.pushRefSpecs) {
            sb.append(' ').append(refSpec);
        }
        return sb.toString();
    }

    public GitPushResult getResult() {
        return this.result;
    }
}

