/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly.blocking;

import com.sun.enterprise.web.connector.grizzly.DefaultProcessorTask;
import com.sun.enterprise.web.connector.grizzly.DefaultReadTask;
import com.sun.enterprise.web.connector.grizzly.Handler;
import com.sun.enterprise.web.connector.grizzly.PipelineStatistic;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.TaskContext;
import com.sun.enterprise.web.connector.grizzly.TaskEvent;
import com.sun.enterprise.web.connector.grizzly.blocking.ProcessorBlockingTask;
import com.sun.enterprise.web.connector.grizzly.blocking.SelectorBlockingThread;
import com.sun.enterprise.web.connector.grizzly.handlers.NoParsingHandler;
import java.io.IOException;
import java.net.Socket;
import java.util.logging.Level;

public class ReadBlockingTask
extends DefaultReadTask {
    protected PipelineStatistic pipelineStat;
    protected boolean isSecure = false;
    private Handler handler;

    public ReadBlockingTask() {
        this.type = 1;
        this.taskContext = new TaskContext();
        this.taskEvent = new TaskEvent<TaskContext>(this.taskContext);
        this.taskEvent.setStatus(0);
    }

    public void attachProcessor(DefaultProcessorTask processorTask) {
        try {
            this.handler = (Handler)Thread.currentThread().getContextClassLoader().loadClass("com.sun.enterprise.web.connector.grizzly.handlers.GlassFishNoParsingHandler").newInstance();
        }
        catch (Exception e) {
            this.handler = new NoParsingHandler();
        }
        this.processorTask = processorTask;
        processorTask.setHandler(this.handler);
    }

    public void doTask() throws IOException {
        Socket socket = this.processorTask.getSocket();
        SelectorBlockingThread blockingSelector = (SelectorBlockingThread)this.selectorThread;
        blockingSelector.setSocketOptions(socket);
        if (this.isSecure) {
            try {
                blockingSelector.getServerSocketFactory().handshake(socket);
            }
            catch (Throwable ex) {
                SelectorThread.getLogger().log(Level.FINE, "selectorThread.sslHandshakeException", ex);
                try {
                    socket.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                this.taskEvent.setStatus(2);
                this.taskEvent(this.taskEvent);
                return;
            }
        }
        this.processorTask.addTaskListener(this);
        this.addTaskListener((ProcessorBlockingTask)this.processorTask);
        this.handler.attachChannel(socket.getChannel());
        this.fireTaskEvent(this.taskEvent);
    }

    public void recycle() {
        this.clearTaskListeners();
        this.taskEvent.setStatus(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finishConnection() {
        Socket socket = this.processorTask.getSocket();
        if (!this.isSecure) {
            try {
                if (!socket.isInputShutdown()) {
                    socket.shutdownInput();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            try {
                if (!socket.isOutputShutdown()) {
                    socket.shutdownOutput();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        try {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                Object var4_6 = null;
                if (!this.isMonitoringEnabled()) return;
                this.getRequestGroupInfo().decreaseCountOpenConnections();
                return;
            }
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            if (!this.isMonitoringEnabled()) throw throwable;
            this.getRequestGroupInfo().decreaseCountOpenConnections();
            throw throwable;
        }
        if (!this.isMonitoringEnabled()) return;
        this.getRequestGroupInfo().decreaseCountOpenConnections();
    }

    public void taskEvent(TaskEvent event) {
        if (event.getStatus() == 2) {
            this.finishConnection();
            if (this.recycle) {
                this.processorTask.recycle();
                this.recycle();
                this.selectorThread.returnTask(this);
            }
        }
    }

    public Socket getSocket() {
        return this.processorTask.getSocket();
    }

    public void setPipelineStatistic(PipelineStatistic pipelineStatistic) {
        this.pipelineStat = pipelineStatistic;
    }

    public PipelineStatistic getPipelineStatistic() {
        return this.pipelineStat;
    }

    public void setSecure(boolean isSecure) {
        this.isSecure = isSecure;
    }

    public boolean getSecure() {
        return this.isSecure;
    }
}

