/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.tooling.admin;

import org.netbeans.modules.glassfish.tooling.admin.Command;
import org.netbeans.modules.glassfish.tooling.admin.CommandChangeAdminPassword;
import org.netbeans.modules.glassfish.tooling.admin.CommandException;
import org.netbeans.modules.glassfish.tooling.admin.ProcessIOContent;
import org.netbeans.modules.glassfish.tooling.admin.RunnerAsadmin;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServer;
import org.netbeans.modules.glassfish.tooling.logging.Logger;
import org.netbeans.modules.glassfish.tooling.utils.OsUtils;

public class RunnerAsadminChangeAdminPassword
extends RunnerAsadmin {
    private static final Logger LOGGER = new Logger(RunnerAsadminChangeAdminPassword.class);
    private static final String DOMAIN_NAME_PARAM = "--domain_name";
    private static final String DOMAINDIR_PARAM = "--domaindir";
    final CommandChangeAdminPassword command;

    private static String query(GlassFishServer server, Command command) {
        String METHOD = "query";
        String domainsFolder = OsUtils.escapeString(server.getDomainsFolder());
        String domainName = OsUtils.escapeString(server.getDomainName());
        if (domainName == null || domainsFolder == null) {
            throw new CommandException(LOGGER.excMsg("query", "nullValue"));
        }
        StringBuilder sb = new StringBuilder(DOMAIN_NAME_PARAM.length() + 1 + domainName.length() + 1 + DOMAINDIR_PARAM.length() + 1 + domainsFolder.length());
        sb.append(DOMAINDIR_PARAM);
        sb.append(' ');
        sb.append(domainsFolder);
        sb.append(' ');
        sb.append(DOMAIN_NAME_PARAM);
        sb.append(' ');
        sb.append(domainName);
        return sb.toString();
    }

    public RunnerAsadminChangeAdminPassword(GlassFishServer server, Command command) {
        super(server, command, RunnerAsadminChangeAdminPassword.query(server, command));
        String METHOD = "init";
        if (!(command instanceof CommandChangeAdminPassword)) {
            throw new CommandException(LOGGER.excMsg("init", "illegalInstance"));
        }
        this.command = (CommandChangeAdminPassword)command;
        this.passwordFile.setAdminNewPassword(this.command.password);
    }

    @Override
    protected ProcessIOContent createProcessIOContent() {
        ProcessIOContent processIOContent = new ProcessIOContent();
        processIOContent.addOutput(new String[]{"Command", "executed successfully"}, new String[]{"Command change-admin-password failed"});
        return processIOContent;
    }
}

