/**
 * The CSSPageRule interface represents a @page rule within a CSS style sheet. The @page rule is used to specify the dimensions, orientation, margins, etc. of a page box for paged media.
 */
var CSSPageRule = {
}
/**
 * The declaration-block of this rule.
 * @syntax cSSPageRule.style
 * @returns {CSSStyleDeclaration} 
 */
CSSPageRule.prototype.style = new CSSStyleDeclaration();

/**
 * The parsable textual representation of the page selector for the rule. Exceptions on setting DOMException SYNTAX_ERR: Raised if the specified CSS string value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this rule is readonly.
 * @syntax cSSPageRule.selectorText
 * @returns {String} 
 */
CSSPageRule.prototype.selectorText = new String();

/**
 * Represents the CSSPageRule prototype object.
 * @syntax CSSPageRule.prototype
 * @static
 */
CSSPageRule.prototype;

