/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.hints;

import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.apisupport.hints.Bundle;
import org.netbeans.modules.apisupport.hints.Hinter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;

public class NavigatorHinter
implements Hinter {
    private static final String PANELS_FOLDER = "Navigator/Panels/";
    private static final String REGISTRATION_BINARY = "org.netbeans.spi.navigator.NavigatorPanel$Registration";

    @Override
    public void process(final Hinter.Context ctx) throws Exception {
        final FileObject file = ctx.file();
        if (!file.getPath().startsWith(PANELS_FOLDER)) {
            return;
        }
        final Object instanceCreate = ctx.instanceAttribute(file);
        if (instanceCreate != null) {
            ctx.addStandardAnnotationHint(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (!ctx.canAccess(NavigatorHinter.REGISTRATION_BINARY)) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.NavigatorHinter_missing_dep(), 2));
                        return null;
                    }
                    ctx.findAndModifyDeclaration(instanceCreate, new Hinter.Context.ModifyDeclarationTask(){

                        @Override
                        public void run(WorkingCopy wc, Element declaration, ModifiersTree modifiers) throws Exception {
                            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                            params.put("mimeType", file.getParent().getPath().substring(NavigatorHinter.PANELS_FOLDER.length()));
                            params.put("position", file.getAttribute("position"));
                            params.put("displayName", "#TODO");
                            String canon = NavigatorHinter.REGISTRATION_BINARY.replace('$', '.');
                            ModifiersTree nue = ctx.addAnnotation(wc, modifiers, canon, canon + "s", params);
                            ctx.delete(file);
                            wc.rewrite((Tree)modifiers, GeneratorUtilities.get((WorkingCopy)wc).importFQNs((Tree)nue));
                        }
                    });
                    return null;
                }
            });
        }
    }
}

