/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.ui;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.Callable;
import org.netbeans.modules.web.browser.api.Page;
import org.netbeans.modules.web.browser.api.PageInspector;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;
import org.openide.windows.WindowSystemEvent;
import org.openide.windows.WindowSystemListener;

public class DomTCController
implements PropertyChangeListener {
    private static final DomTCController DEFAULT = new DomTCController();

    private DomTCController() {
        PageInspector inspector = PageInspector.getDefault();
        inspector.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public static DomTCController getDefault() {
        return DEFAULT;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("model".equals(propName)) {
            this.pageInspected();
        }
    }

    private void pageInspected() {
        this.updateDomTC();
    }

    private void updateDomTC() {
        if (EventQueue.isDispatchThread()) {
            this.updateDomTC0();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DomTCController.this.updateDomTC0();
                }
            });
        }
    }

    static TopComponentGroup getDOMTCGroup() {
        return WindowManager.getDefault().findTopComponentGroup("DomTree");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDomTC0() {
        DomTCController domTCController = this;
        synchronized (domTCController) {
            TopComponentGroup group = DomTCController.getDOMTCGroup();
            Page inspectedPage = PageInspector.getDefault().getPage();
            if (inspectedPage == null) {
                group.close();
            } else {
                TopComponent tc = WindowManager.getDefault().findTopComponent("DomTC");
                boolean wasOpened = tc.isOpened();
                group.open();
                if (!wasOpened && tc.isOpened() && !WindowManager.getDefault().isTopComponentMinimized(tc)) {
                    tc.requestVisible();
                }
            }
        }
    }

    public static class ShutdownHook
    implements Callable<Boolean>,
    WindowSystemListener {
        private boolean listenerInstalled;

        @Override
        public Boolean call() throws Exception {
            if (!this.listenerInstalled) {
                this.listenerInstalled = true;
                WindowManager.getDefault().addWindowSystemListener((WindowSystemListener)this);
            }
            return Boolean.TRUE;
        }

        public void beforeLoad(WindowSystemEvent event) {
        }

        public void afterLoad(WindowSystemEvent event) {
        }

        public void beforeSave(WindowSystemEvent event) {
            DomTCController.getDOMTCGroup().close();
        }

        public void afterSave(WindowSystemEvent event) {
        }
    }
}

