/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.api.sql.execute;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.db.api.sql.execute.SQLScriptStatement;
import org.netbeans.modules.db.sql.execute.SQLExecuteHelper;
import org.netbeans.modules.db.sql.execute.StatementInfo;

public final class SQLScript {
    private final List<SQLScriptStatement> statements;

    public static SQLScript create(String sql) {
        ArrayList<SQLScriptStatement> statements = new ArrayList<SQLScriptStatement>();
        for (StatementInfo statement : SQLExecuteHelper.split(sql)) {
            String text = sql.substring(statement.getRawStartOffset(), statement.getRawEndOffset());
            statements.add(new SQLScriptStatement(text, statement.getRawStartOffset(), statement.getRawEndOffset()));
        }
        return new SQLScript(statements);
    }

    private SQLScript(List<SQLScriptStatement> statements) {
        this.statements = statements;
    }

    public SQLScriptStatement getStatementAtOffset(int offset) {
        for (SQLScriptStatement statement : this.statements) {
            if (offset < statement.getStartOffset() || offset > statement.getEndOffset()) continue;
            return statement;
        }
        return null;
    }
}

