/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.saxtree;

import nu.validator.saxtree.Node;
import nu.validator.saxtree.NullLexicalHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public final class TreeParser
implements Locator {
    private final ContentHandler contentHandler;
    private final LexicalHandler lexicalHandler;
    private Locator locatorDelegate;

    public TreeParser(ContentHandler contentHandler, LexicalHandler lexicalHandler) {
        if (contentHandler == null) {
            throw new IllegalArgumentException("contentHandler was null.");
        }
        this.contentHandler = contentHandler;
        this.lexicalHandler = lexicalHandler == null ? new NullLexicalHandler() : lexicalHandler;
    }

    public void parse(Node node) throws SAXException {
        this.contentHandler.setDocumentLocator(this);
        Node current = node;
        block0: while (true) {
            current.visit(this);
            Node next = current.getFirstChild();
            if (next != null) {
                current = next;
                continue;
            }
            while (true) {
                current.revisit(this);
                if (current == node) {
                    return;
                }
                next = current.getNextSibling();
                if (next != null) {
                    current = next;
                    continue block0;
                }
                current = current.getParentNode();
            }
            break;
        }
    }

    void characters(char[] ch, int start, int length, Locator locator) throws SAXException {
        this.locatorDelegate = locator;
        this.contentHandler.characters(ch, start, length);
    }

    void endDocument(Locator locator) throws SAXException {
        this.locatorDelegate = locator;
        this.contentHandler.endDocument();
    }

    void endElement(String uri, String localName, String qName, Locator locator) throws SAXException {
        this.locatorDelegate = locator;
        this.contentHandler.endElement(uri, localName, qName);
    }

    void endPrefixMapping(String prefix, Locator locator) throws SAXException {
        this.locatorDelegate = locator;
        this.contentHandler.endPrefixMapping(prefix);
    }

    void ignorableWhitespace(char[] ch, int start, int length, Locator locator) throws SAXException {
        this.locatorDelegate = locator;
        this.contentHandler.ignorableWhitespace(ch, start, length);
    }

    void processingInstruction(String target, String data, Locator locator) throws SAXException {
        this.locatorDelegate = locator;
        this.contentHandler.processingInstruction(target, data);
    }

    void skippedEntity(String name, Locator locator) throws SAXException {
        this.locatorDelegate = locator;
        this.contentHandler.skippedEntity(name);
    }

    void startDocument(Locator locator) throws SAXException {
        this.locatorDelegate = locator;
        this.contentHandler.startDocument();
    }

    void startElement(String uri, String localName, String qName, Attributes atts, Locator locator) throws SAXException {
        this.locatorDelegate = locator;
        this.contentHandler.startElement(uri, localName, qName, atts);
    }

    void startPrefixMapping(String prefix, String uri, Locator locator) throws SAXException {
        this.locatorDelegate = locator;
        this.contentHandler.startPrefixMapping(prefix, uri);
    }

    void comment(char[] ch, int start, int length, Locator locator) throws SAXException {
        this.locatorDelegate = locator;
        this.lexicalHandler.comment(ch, start, length);
    }

    void endCDATA(Locator locator) throws SAXException {
        this.locatorDelegate = locator;
        this.lexicalHandler.endCDATA();
    }

    void endDTD(Locator locator) throws SAXException {
        this.locatorDelegate = locator;
        this.lexicalHandler.endDTD();
    }

    void endEntity(String name, Locator locator) throws SAXException {
        this.locatorDelegate = locator;
        this.lexicalHandler.endEntity(name);
    }

    void startCDATA(Locator locator) throws SAXException {
        this.locatorDelegate = locator;
        this.lexicalHandler.startCDATA();
    }

    void startDTD(String name, String publicId, String systemId, Locator locator) throws SAXException {
        this.locatorDelegate = locator;
        this.lexicalHandler.startDTD(name, publicId, systemId);
    }

    void startEntity(String name, Locator locator) throws SAXException {
        this.locatorDelegate = locator;
        this.lexicalHandler.startEntity(name);
    }

    public int getColumnNumber() {
        if (this.locatorDelegate == null) {
            return -1;
        }
        return this.locatorDelegate.getColumnNumber();
    }

    public int getLineNumber() {
        if (this.locatorDelegate == null) {
            return -1;
        }
        return this.locatorDelegate.getLineNumber();
    }

    public String getPublicId() {
        if (this.locatorDelegate == null) {
            return null;
        }
        return this.locatorDelegate.getPublicId();
    }

    public String getSystemId() {
        if (this.locatorDelegate == null) {
            return null;
        }
        return this.locatorDelegate.getSystemId();
    }
}

