/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.source.parsing.Archive;
import org.netbeans.modules.java.source.parsing.CachingArchiveProvider;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.openide.util.Exceptions;
import org.openide.util.Pair;
import org.openide.util.Parameters;

public final class CachingArchiveClassLoader
extends ClassLoader {
    private static final String RES_PROCESSORS = "META-INF/services/javax.annotation.processing.Processor";
    private static final int INI_SIZE = 16384;
    private static final Logger LOG = Logger.getLogger(CachingArchiveClassLoader.class.getName());
    private static final ReentrantReadWriteLock LOCK = new ReentrantReadWriteLock();
    private final List<Pair<URL, Archive>> archives;
    private final Optional<Consumer<? super URL>> usedRoots;
    private byte[] buffer;

    private CachingArchiveClassLoader(@NonNull List<Pair<URL, Archive>> archives, @NullAllowed ClassLoader parent, @NullAllowed Consumer<? super URL> usedRoots) {
        super(parent);
        assert (archives != null);
        this.archives = archives;
        this.usedRoots = Optional.ofNullable(usedRoots);
    }

    @Override
    protected Class<?> findClass(final String name) throws ClassNotFoundException {
        final StringBuilder sb = new StringBuilder(FileObjects.convertPackage2Folder(name, '/'));
        sb.append(JavaFileObject.Kind.CLASS.extension);
        Class<?> c = null;
        try {
            c = (Class<?>)CachingArchiveClassLoader.readAction(new Callable<Class<?>>(){

                @Override
                public Class<?> call() throws Exception {
                    FileObject file = CachingArchiveClassLoader.this.findFileObject(sb.toString());
                    if (file != null) {
                        try {
                            String pack;
                            int len = CachingArchiveClassLoader.this.readJavaFileObject(file);
                            int lastDot = name.lastIndexOf(46);
                            if (lastDot != -1 && CachingArchiveClassLoader.this.getPackage(pack = name.substring(0, lastDot)) == null) {
                                CachingArchiveClassLoader.this.definePackage(pack, null, null, null, null, null, null, null);
                            }
                            return CachingArchiveClassLoader.this.defineClass(name, CachingArchiveClassLoader.this.buffer, 0, len);
                        }
                        catch (FileNotFoundException fnf) {
                            LOG.log(Level.FINE, "Resource: {0} does not exist.", file.toUri());
                        }
                        catch (IOException ioe) {
                            LOG.log(Level.INFO, "Resource: {0} cannot be read.", file.toUri());
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return c != null ? c : super.findClass(name);
    }

    @Override
    protected URL findResource(final String name) {
        FileObject file = null;
        try {
            file = CachingArchiveClassLoader.readAction(new Callable<FileObject>(){

                @Override
                public FileObject call() throws Exception {
                    return CachingArchiveClassLoader.this.findFileObject(name);
                }
            });
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        if (file != null) {
            try {
                return file.toUri().toURL();
            }
            catch (MalformedURLException ex) {
                LOG.log(Level.INFO, ex.getMessage(), ex);
            }
        }
        return super.findResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(final String name) throws IOException {
        try {
            return CachingArchiveClassLoader.readAction(new Callable<Enumeration<URL>>(){

                @Override
                public Enumeration<URL> call() throws Exception {
                    Vector<URL> v = new Vector<URL>();
                    for (Pair p : CachingArchiveClassLoader.this.archives) {
                        Archive archive = (Archive)p.second();
                        JavaFileObject file = archive.getFile(name);
                        if (file == null) continue;
                        v.add(file.toUri().toURL());
                        CachingArchiveClassLoader.this.usedRoots.map(c -> CachingArchiveClassLoader.RES_PROCESSORS.equals(name) ? null : c).ifPresent(c -> c.accept(p.first()));
                    }
                    return v.elements();
                }
            });
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readJavaFileObject(FileObject jfo) throws IOException {
        assert (LOCK.getReadLockCount() > 0);
        if (this.buffer == null) {
            this.buffer = new byte[16384];
        }
        int len = 0;
        try (InputStream in = jfo.openInputStream();){
            while (true) {
                int l;
                if (this.buffer.length == len) {
                    byte[] nb = new byte[2 * this.buffer.length];
                    System.arraycopy(this.buffer, 0, nb, 0, len);
                    this.buffer = nb;
                }
                if ((l = in.read(this.buffer, len, this.buffer.length - len)) <= 0) {
                    break;
                }
                len += l;
            }
        }
        return len;
    }

    private FileObject findFileObject(String resName) {
        assert (LOCK.getReadLockCount() > 0);
        for (Pair<URL, Archive> p : this.archives) {
            Archive archive = (Archive)p.second();
            try {
                JavaFileObject file = archive.getFile(resName);
                if (file == null) continue;
                this.usedRoots.ifPresent(c -> c.accept(p.first()));
                return file;
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "Cannot read: " + archive, ex);
            }
        }
        return null;
    }

    public static ClassLoader forClassPath(@NonNull ClassPath classPath, @NullAllowed ClassLoader parent, @NullAllowed Consumer<? super URL> usedRoots) {
        Parameters.notNull((CharSequence)"classPath", (Object)classPath);
        List entries = classPath.entries();
        URL[] urls = new URL[entries.size()];
        Iterator eit = entries.iterator();
        int i = 0;
        while (eit.hasNext()) {
            urls[i] = ((ClassPath.Entry)eit.next()).getURL();
            ++i;
        }
        return CachingArchiveClassLoader.forURLs(urls, parent, usedRoots);
    }

    public static ClassLoader forURLs(@NonNull URL[] urls, @NullAllowed ClassLoader parent, @NullAllowed Consumer<? super URL> usedRoots) {
        Parameters.notNull((CharSequence)"urls", (Object)urls);
        ArrayList<Pair<URL, Archive>> archives = new ArrayList<Pair<URL, Archive>>(urls.length);
        for (URL url : urls) {
            Archive arch = CachingArchiveProvider.getDefault().getArchive(url, false);
            if (arch == null) continue;
            archives.add((Pair<URL, Archive>)Pair.of((Object)url, (Object)arch));
        }
        return new CachingArchiveClassLoader(archives, parent, usedRoots);
    }

    public static <T> T readAction(@NonNull Callable<T> action) throws Exception {
        Parameters.notNull((CharSequence)"action", action);
        LOCK.readLock().lock();
        try {
            LOG.log(Level.FINE, "Read locked by {0}", Thread.currentThread());
            T t = action.call();
            return t;
        }
        finally {
            LOCK.readLock().unlock();
        }
    }

    public static <T> T writeAction(@NonNull Callable<T> action) throws Exception {
        Parameters.notNull((CharSequence)"action", action);
        LOCK.writeLock().lock();
        try {
            LOG.log(Level.FINE, "Write locked by {0}", Thread.currentThread());
            T t = action.call();
            return t;
        }
        finally {
            LOCK.writeLock().unlock();
        }
    }
}

