/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.SideEffectVisitor;
import org.netbeans.modules.java.hints.StopProcessing;
import org.netbeans.modules.java.hints.bugs.Bundle;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.introduce.TreeUtils;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;

public class SuspiciousToArray {
    public static ErrorDescription run(HintContext ctx) {
        Fix fix;
        String msg;
        TypeMirror colItemType;
        TypeMirror colType;
        TreePath expr = ctx.getPath();
        TreePath colPath = (TreePath)ctx.getVariables().get("$c");
        CompilationInfo ci = ctx.getInfo();
        if (colPath != null) {
            colType = ci.getTrees().getTypeMirror(colPath);
        } else {
            TreePath clazz = TreeUtils.findClass(expr);
            if (clazz == null) {
                return null;
            }
            colType = ci.getTrees().getTypeMirror(clazz);
        }
        if (!Utilities.isValidType(colType) || colType.getKind() != TypeKind.DECLARED) {
            return null;
        }
        TreePath arrPath = (TreePath)ctx.getVariables().get("$arr");
        TypeMirror arrType = ci.getTrees().getTypeMirror(arrPath);
        if (!Utilities.isValidType(arrType) || arrType.getKind() != TypeKind.ARRAY) {
            return null;
        }
        arrType = SourceUtils.resolveCapturedType((CompilationInfo)ci, (TypeMirror)arrType);
        TypeMirror compType = ((ArrayType)arrType).getComponentType();
        StringBuilder sb = new StringBuilder();
        if (colPath != null) {
            int posStart = (int)ci.getTrees().getSourcePositions().getStartPosition(ci.getCompilationUnit(), colPath.getLeaf());
            int posEnd = (int)ci.getTrees().getSourcePositions().getEndPosition(ci.getCompilationUnit(), colPath.getLeaf());
            sb.append(ci.getSnapshot().getText().subSequence(posStart, posEnd)).append(".");
        }
        sb.append("iterator().next()");
        ExpressionTree colItemExpr = ci.getTreeUtilities().parseExpression(sb.toString(), null);
        if (colItemExpr.getKind() != Tree.Kind.METHOD_INVOCATION) {
            return null;
        }
        Scope s = ci.getTrees().getScope(ctx.getPath());
        ArrayList diags = new ArrayList();
        TypeMirror argType = colItemType = ci.getTreeUtilities().attributeTree((Tree)colItemExpr, s);
        TypeMirror resType = null;
        if (argType == null || argType.getKind() == TypeKind.DECLARED && ((TypeElement)((DeclaredType)argType).asElement()).getQualifiedName().contentEquals("java.lang.Object")) {
            argType = null;
            for (TreePath parent = expr.getParentPath(); parent != null && parent.getLeaf().getKind() == Tree.Kind.TYPE_CAST; parent = parent.getParentPath()) {
                TypeMirror tm = ci.getTrees().getTypeMirror(parent);
                if (tm.getKind() != TypeKind.ARRAY) continue;
                resType = tm;
            }
            if (resType != null) {
                resType = ((ArrayType)resType).getComponentType();
                if (ci.getTypes().isSameType(compType, resType)) {
                    return null;
                }
            }
        } else {
            resType = argType;
            if (ci.getTypes().isAssignable(resType, compType)) {
                return null;
            }
        }
        if (!Utilities.isValidType(resType)) {
            return null;
        }
        resType = SourceUtils.resolveCapturedType((CompilationInfo)ci, (TypeMirror)resType);
        String string = msg = argType == null ? Bundle.TEXT_SuspiciousToArrayCast(compType, resType) : Bundle.TEXT_SuspiciousToArrayCol(compType, argType);
        if (arrPath.getLeaf().getKind() == Tree.Kind.NEW_ARRAY) {
            fix = new ChangeArrayTypeFix(TreePathHandle.create((TreePath)arrPath, (CompilationInfo)ci), colPath == null ? null : TreePathHandle.create((TreePath)colPath, (CompilationInfo)ci), TypeMirrorHandle.create((TypeMirror)resType), ci.getTypeUtilities().getTypeName(resType, new TypeUtilities.TypeNameOptions[0]).toString()).toEditorFix();
        } else {
            SideEffectVisitor sev = new SideEffectVisitor(ctx);
            try {
                if (colPath != null) {
                    sev.scan(colPath, ci);
                }
                fix = new ChangeArrayTypeFix(TreePathHandle.create((TreePath)arrPath, (CompilationInfo)ci), colPath == null ? null : TreePathHandle.create((TreePath)colPath, (CompilationInfo)ci), TypeMirrorHandle.create((TypeMirror)resType), ci.getTypeUtilities().getTypeName(resType, new TypeUtilities.TypeNameOptions[0]).toString()).toEditorFix();
            }
            catch (StopProcessing ex) {
                fix = null;
            }
        }
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)arrPath, (String)msg, (Fix[])new Fix[]{fix});
    }

    private static class ChangeArrayTypeFix
    extends JavaFix {
        private final TypeMirrorHandle ctype;
        private final TreePathHandle colReference;
        private final String typeName;

        public ChangeArrayTypeFix(TreePathHandle handle, TreePathHandle colReference, TypeMirrorHandle ctype, String typeName) {
            super(handle);
            this.ctype = ctype;
            this.typeName = typeName;
            this.colReference = colReference;
        }

        protected String getText() {
            return Bundle.FIX_ChangeToArrayType(this.typeName);
        }

        private int numberOfDimensions(TypeMirror arr) {
            int dim = 0;
            while (arr.getKind() == TypeKind.ARRAY) {
                arr = ((ArrayType)arr).getComponentType();
                ++dim;
            }
            return dim;
        }

        private void rewriteNewArrayTree(WorkingCopy copy, TreeMaker mk, TreePath natPath, TypeMirror compType) {
            int newDim;
            NewArrayTree nat = (NewArrayTree)natPath.getLeaf();
            TypeMirror existing = copy.getTrees().getTypeMirror(natPath);
            int existingDim = this.numberOfDimensions(existing);
            if (existingDim == (newDim = this.numberOfDimensions(compType)) + 1) {
                copy.rewrite(nat.getType(), mk.Type(compType));
                return;
            }
            ArrayList<? extends ExpressionTree> l = new ArrayList<ExpressionTree>(nat.getDimensions().subList(0, Math.min(newDim + 1, nat.getDimensions().size())));
            NewArrayTree replacement = mk.NewArray(mk.Type(compType), l, null);
            GeneratorUtilities.get((WorkingCopy)copy).copyComments((Tree)nat, (Tree)replacement, true);
            GeneratorUtilities.get((WorkingCopy)copy).copyComments((Tree)nat, (Tree)replacement, false);
            copy.rewrite((Tree)nat, (Tree)replacement);
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            NewArrayTree nat;
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath path = ctx.getPath();
            TypeMirror compType = this.ctype.resolve((CompilationInfo)wc);
            if (compType == null) {
                return;
            }
            TreeMaker mk = wc.getTreeMaker();
            Tree l = path.getLeaf();
            if (l.getKind() == Tree.Kind.NEW_ARRAY && (nat = (NewArrayTree)l).getInitializers() == null) {
                this.rewriteNewArrayTree(wc, mk, path, compType);
                return;
            }
            TreePath colRef = null;
            if (this.colReference != null && (colRef = this.colReference.resolve((CompilationInfo)wc)) == null) {
                return;
            }
            GeneratorUtilities gu = GeneratorUtilities.get((WorkingCopy)wc);
            Tree lc = gu.importComments(l, wc.getCompilationUnit());
            NewArrayTree newArrayTree = mk.NewArray(mk.Type(compType), Collections.singletonList(mk.MethodInvocation(Collections.emptyList(), colRef == null ? mk.Identifier((CharSequence)"size") : mk.MemberSelect((ExpressionTree)colRef.getLeaf(), (CharSequence)"size"), Collections.emptyList())), null);
            gu.copyComments(lc, (Tree)newArrayTree, true);
            gu.copyComments(lc, (Tree)newArrayTree, false);
            wc.rewrite(lc, (Tree)newArrayTree);
        }
    }
}

