/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CaseExpression
extends AbstractExpression {
    private String caseIdentifier;
    private AbstractExpression caseOperand;
    private AbstractExpression elseExpression;
    private String elseIdentifier;
    private String endIdentifier;
    private boolean hasSpaceAfterCase;
    private boolean hasSpaceAfterCaseOperand;
    private boolean hasSpaceAfterElse;
    private boolean hasSpaceAfterElseExpression;
    private boolean hasSpaceAfterWhenClauses;
    private ParsingType parsingType;
    private AbstractExpression whenClauses;

    public CaseExpression(AbstractExpression parent) {
        super(parent, "CASE");
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getCaseOperand().accept(visitor);
        this.getWhenClauses().accept(visitor);
        this.getElseExpression().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getCaseOperand());
        children.add(this.getWhenClauses());
        children.add(this.getElseExpression());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        children.add(this.buildStringExpression("CASE"));
        if (this.hasSpaceAfterCase) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.caseOperand != null) {
            children.add(this.caseOperand);
        }
        if (this.hasSpaceAfterCaseOperand) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.whenClauses != null) {
            children.add(this.whenClauses);
        }
        if (this.hasSpaceAfterWhenClauses) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.elseIdentifier != null) {
            children.add(this.buildStringExpression("ELSE"));
        }
        if (this.hasSpaceAfterElse) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.elseExpression != null) {
            children.add(this.elseExpression);
        }
        if (this.hasSpaceAfterElseExpression) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.endIdentifier != null) {
            children.add(this.buildStringExpression("END"));
        }
    }

    @Override
    public JPQLQueryBNF findQueryBNF(Expression expression) {
        if (this.caseOperand != null && this.caseOperand.isAncestor(expression)) {
            return this.getQueryBNF("case_operand");
        }
        if (this.whenClauses != null && this.whenClauses.isAncestor(expression)) {
            return this.getQueryBNF("when_clause");
        }
        if (this.elseExpression != null && this.elseExpression.isAncestor(expression)) {
            return this.getQueryBNF("else_expression");
        }
        return super.findQueryBNF(expression);
    }

    public String getActualCaseIdentifier() {
        return this.caseIdentifier;
    }

    public String getActualElseIdentifier() {
        return this.elseIdentifier != null ? this.elseIdentifier : "";
    }

    public String getActualEndIdentifier() {
        return this.endIdentifier != null ? this.endIdentifier : "";
    }

    public Expression getCaseOperand() {
        if (this.caseOperand == null) {
            this.caseOperand = this.buildNullExpression();
        }
        return this.caseOperand;
    }

    public AbstractExpression getElseExpression() {
        if (this.elseExpression == null) {
            this.elseExpression = this.buildNullExpression();
        }
        return this.elseExpression;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("general_case_expression");
    }

    public AbstractExpression getWhenClauses() {
        if (this.whenClauses == null) {
            this.whenClauses = this.buildNullExpression();
        }
        return this.whenClauses;
    }

    public boolean hasCaseOperand() {
        return this.caseOperand != null && !this.caseOperand.isNull();
    }

    public boolean hasElse() {
        return this.elseIdentifier != null;
    }

    public boolean hasElseExpression() {
        return this.elseExpression != null && !this.elseExpression.isNull();
    }

    public boolean hasEnd() {
        return this.endIdentifier != null;
    }

    public boolean hasSpaceAfterCase() {
        return this.hasSpaceAfterCase;
    }

    public boolean hasSpaceAfterCaseOperand() {
        return this.hasSpaceAfterCaseOperand;
    }

    public boolean hasSpaceAfterElse() {
        return this.hasSpaceAfterElse;
    }

    public boolean hasSpaceAfterElseExpression() {
        return this.hasSpaceAfterElseExpression;
    }

    public boolean hasSpaceAfterWhenClauses() {
        return this.hasSpaceAfterWhenClauses;
    }

    public boolean hasWhenClauses() {
        return this.whenClauses != null && !this.whenClauses.isNull();
    }

    @Override
    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        if (this.parsingType == ParsingType.CASE) {
            return word.equalsIgnoreCase("WHEN") || word.equalsIgnoreCase("ELSE") || word.equalsIgnoreCase("END") || super.isParsingComplete(wordParser, word, expression);
        }
        if (this.parsingType == ParsingType.WHEN) {
            return word.equalsIgnoreCase("ELSE") || word.equalsIgnoreCase("END") || super.isParsingComplete(wordParser, word, expression);
        }
        return word.equalsIgnoreCase("END") || super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.caseIdentifier = wordParser.moveForward("CASE");
        this.hasSpaceAfterCase = wordParser.skipLeadingWhitespace() > 0;
        this.parsingType = ParsingType.CASE;
        if (!wordParser.startsWithIdentifier("WHEN")) {
            this.caseOperand = this.parse(wordParser, "case_operand", tolerant);
            this.hasSpaceAfterCaseOperand = wordParser.skipLeadingWhitespace() > 0;
        }
        this.parsingType = ParsingType.WHEN;
        this.whenClauses = this.parse(wordParser, "when_clause", tolerant);
        boolean bl = this.hasSpaceAfterWhenClauses = wordParser.skipLeadingWhitespace() > 0;
        if (!tolerant || wordParser.startsWithIdentifier("ELSE")) {
            this.elseIdentifier = wordParser.moveForward("ELSE");
            this.hasSpaceAfterElse = wordParser.skipLeadingWhitespace() > 0;
        }
        this.parsingType = ParsingType.ELSE;
        this.elseExpression = this.parse(wordParser, "else_expression", tolerant);
        boolean bl2 = this.hasSpaceAfterElseExpression = wordParser.skipLeadingWhitespace() > 0;
        if (!tolerant || wordParser.startsWithIdentifier("END")) {
            this.endIdentifier = wordParser.moveForward("END");
        }
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        writer.append(actual ? this.caseIdentifier : "CASE");
        if (this.hasSpaceAfterCase) {
            writer.append(' ');
        }
        if (this.caseOperand != null) {
            this.caseOperand.toParsedText(writer, actual);
        }
        if (this.hasSpaceAfterCaseOperand) {
            writer.append(' ');
        }
        if (this.whenClauses != null) {
            this.whenClauses.toParsedText(writer, actual);
        }
        if (this.hasSpaceAfterWhenClauses) {
            writer.append(' ');
        }
        if (this.elseIdentifier != null) {
            writer.append(actual ? this.elseIdentifier : "ELSE");
        }
        if (this.hasSpaceAfterElse) {
            writer.append(' ');
        }
        if (this.elseExpression != null) {
            this.elseExpression.toParsedText(writer, actual);
        }
        if (this.hasSpaceAfterElseExpression) {
            writer.append(' ');
        }
        if (this.endIdentifier != null) {
            writer.append(actual ? this.endIdentifier : "END");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ParsingType {
        CASE,
        ELSE,
        WHEN;

    }
}

