/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.seg.Other;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.AhoCorasick.AhoCorasickDoubleArrayTrie;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.seg.DictionaryBasedSegment;
import com.hankcs.hanlp.seg.Segment;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.utility.Predefine;
import com.hankcs.hanlp.utility.TextUtility;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;

public class AhoCorasickDoubleArrayTrieSegment
extends DictionaryBasedSegment {
    AhoCorasickDoubleArrayTrie<CoreDictionary.Attribute> trie;

    public AhoCorasickDoubleArrayTrieSegment() throws IOException {
        this(HanLP.Config.CoreDictionaryPath);
    }

    public AhoCorasickDoubleArrayTrieSegment(TreeMap<String, CoreDictionary.Attribute> dictionary) {
        this(new AhoCorasickDoubleArrayTrie<CoreDictionary.Attribute>(dictionary));
    }

    public AhoCorasickDoubleArrayTrieSegment(AhoCorasickDoubleArrayTrie<CoreDictionary.Attribute> trie) {
        this.trie = trie;
        this.config.useCustomDictionary = false;
        this.config.speechTagging = false;
    }

    public AhoCorasickDoubleArrayTrieSegment(String ... dictionaryPaths) throws IOException {
        this(new AhoCorasickDoubleArrayTrie<CoreDictionary.Attribute>(IOUtil.loadDictionary(dictionaryPaths)));
    }

    @Override
    protected List<Term> segSentence(char[] sentence) {
        if (this.trie == null) {
            Predefine.logger.warning("\u8fd8\u672a\u52a0\u8f7d\u4efb\u4f55\u8bcd\u5178");
            return Collections.emptyList();
        }
        final int[] wordNet = new int[sentence.length];
        Arrays.fill(wordNet, 1);
        final Nature[] natureArray = this.config.speechTagging ? new Nature[sentence.length] : null;
        this.trie.parseText(sentence, new AhoCorasickDoubleArrayTrie.IHit<CoreDictionary.Attribute>(){

            @Override
            public void hit(int begin, int end, CoreDictionary.Attribute value) {
                int length = end - begin;
                if (length > wordNet[begin]) {
                    wordNet[begin] = length;
                    if (((AhoCorasickDoubleArrayTrieSegment)AhoCorasickDoubleArrayTrieSegment.this).config.speechTagging) {
                        natureArray[begin] = value.nature[0];
                    }
                }
            }
        });
        LinkedList<Term> termList = new LinkedList<Term>();
        this.posTag(sentence, wordNet, natureArray);
        for (int i = 0; i < wordNet.length; i += wordNet[i]) {
            Term term = new Term(new String(sentence, i, wordNet[i]), this.config.speechTagging ? (natureArray[i] == null ? Nature.nz : natureArray[i]) : null);
            term.offset = i;
            termList.add(term);
        }
        return termList;
    }

    @Override
    public Segment enableCustomDictionary(boolean enable) {
        throw new UnsupportedOperationException("AhoCorasickDoubleArrayTrieSegment\u6682\u65f6\u4e0d\u652f\u6301\u7528\u6237\u8bcd\u5178\u3002");
    }

    public AhoCorasickDoubleArrayTrie<CoreDictionary.Attribute> getTrie() {
        return this.trie;
    }

    public void setTrie(AhoCorasickDoubleArrayTrie<CoreDictionary.Attribute> trie) {
        this.trie = trie;
    }

    public AhoCorasickDoubleArrayTrieSegment loadDictionary(String ... pathArray) {
        this.trie = new AhoCorasickDoubleArrayTrie();
        TreeMap<String, CoreDictionary.Attribute> map = null;
        try {
            map = IOUtil.loadDictionary(pathArray);
        }
        catch (IOException e) {
            Predefine.logger.warning("\u52a0\u8f7d\u8bcd\u5178\u5931\u8d25\n" + TextUtility.exceptionToString(e));
            return this;
        }
        if (map != null && !map.isEmpty()) {
            this.trie.build(map);
        }
        return this;
    }
}

