/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import com.github.difflib.DiffUtils;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.DeltaType;
import com.github.difflib.text.DiffRowGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import org.languagetool.tools.PseudoMatch;

public class DiffsAsMatches {
    public List<PseudoMatch> getPseudoMatches(String original, String revised) {
        ArrayList<PseudoMatch> matches = new ArrayList<PseudoMatch>();
        List origList = (List)DiffRowGenerator.SPLITTER_BY_WORD.apply(original);
        List revList = (List)DiffRowGenerator.SPLITTER_BY_WORD.apply(revised);
        List inlineDeltas = DiffUtils.diff((List)origList, (List)revList, (BiPredicate)DiffRowGenerator.DEFAULT_EQUALIZER).getDeltas();
        PseudoMatch lastMatch = null;
        AbstractDelta lastInlineDelta = null;
        for (AbstractDelta inlineDelta : inlineDeltas) {
            PseudoMatch match;
            String newReplacement;
            String replacement = String.join((CharSequence)"", inlineDelta.getTarget().getLines());
            int fromPos = 0;
            int errorIndex = inlineDelta.getSource().getPosition();
            int indexCorrection = 0;
            if (inlineDelta.getType() == DeltaType.INSERT && errorIndex - (indexCorrection = 2) < 0) {
                indexCorrection = 0;
            }
            for (int i = 0; i < errorIndex - indexCorrection; ++i) {
                fromPos += ((String)origList.get(i)).length();
            }
            boolean wasLastWhitespace = false;
            if (errorIndex - 1 < origList.size() && errorIndex - 1 > -1) {
                wasLastWhitespace = ((String)origList.get(errorIndex - 1)).equals(" ");
            }
            String underlinedError = String.join((CharSequence)"", inlineDelta.getSource().getLines());
            int toPos = fromPos + underlinedError.length();
            String prefixReplacement = "";
            for (int i = errorIndex - indexCorrection; i < errorIndex; ++i) {
                toPos += ((String)origList.get(i)).length();
                prefixReplacement = prefixReplacement + (String)origList.get(i);
            }
            replacement = prefixReplacement + replacement;
            if (fromPos == 0 && toPos == 0) {
                toPos = ((String)origList.get(0)).length();
                replacement = replacement + (String)origList.get(0);
            }
            if (inlineDelta.getType() == DeltaType.INSERT && replacement.endsWith(" ") && replacement.length() > 2 && wasLastWhitespace) {
                replacement = replacement.substring(0, replacement.length() - 1);
                --toPos;
            }
            if (lastMatch != null && lastInlineDelta.getType() == DeltaType.CHANGE && inlineDelta.getType() == DeltaType.INSERT && ((String)origList.get(inlineDelta.getSource().getPosition() - 1)).equals(" ") && inlineDelta.getSource().getPosition() - 1 == lastInlineDelta.getSource().getPosition() + lastInlineDelta.getSource().getLines().size()) {
                newReplacement = lastMatch.getReplacements().get(0) + replacement.substring(toPos - fromPos);
                match = new PseudoMatch(newReplacement, lastMatch.getFromPos(), toPos);
                matches.remove(matches.size() - 1);
            } else if (lastMatch != null && inlineDelta.getType() == DeltaType.DELETE && wasLastWhitespace && lastMatch.getToPos() + 1 == fromPos) {
                newReplacement = lastMatch.getReplacements().get(0);
                match = new PseudoMatch(newReplacement, lastMatch.getFromPos(), toPos - 1);
                matches.remove(matches.size() - 1);
            } else {
                match = new PseudoMatch(replacement, fromPos, toPos);
            }
            matches.add(match);
            lastMatch = match;
            lastInlineDelta = inlineDelta;
        }
        return matches;
    }
}

