/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.MultiThreadedJLanguageTool;
import org.languagetool.rules.RemoteRuleFilters;
import org.languagetool.rules.Rule;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.PatternRuleTest;

public class RemoteRuleFilterTest
extends PatternRuleTest {
    @Override
    protected List<String> getGrammarFileNames(Language lang) {
        return Collections.singletonList(RemoteRuleFilters.getFilename((Language)lang));
    }

    @Override
    public void runTestForLanguage(Language lang) throws IOException {
        System.out.println("Running remote rule filter tests for " + lang.getName() + "... ");
        MultiThreadedJLanguageTool lt = RemoteRuleFilterTest.createToolForTesting(lang);
        List<AbstractPatternRule> rules = RemoteRuleFilters.load((Language)lang).values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        MultiThreadedJLanguageTool allRulesLt = new MultiThreadedJLanguageTool(lang);
        allRulesLt.disableRules(allRulesLt.getAllRules().stream().map(Rule::getId).collect(Collectors.toList()));
        rules.forEach(arg_0 -> ((MultiThreadedJLanguageTool)allRulesLt).addRule(arg_0));
        this.validateRuleIds(lang, (JLanguageTool)allRulesLt);
        this.validateSentenceStartNotInMarker((JLanguageTool)allRulesLt);
        this.testRegexSyntax(lang, rules);
        this.testGrammarRulesFromXML(rules, (JLanguageTool)allRulesLt, lang);
        System.out.println(rules.size() + " rules tested.");
        allRulesLt.shutdown();
        lt.shutdown();
    }
}

