/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.gosen.tokenAttributes;

import java.util.Arrays;
import java.util.List;
import net.java.sen.dictionary.Morpheme;
import org.apache.lucene.analysis.gosen.ToStringUtil;
import org.apache.lucene.analysis.gosen.tokenAttributes.PronunciationsAttribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;

public class PronunciationsAttributeImpl
extends AttributeImpl
implements PronunciationsAttribute,
Cloneable {
    private static final long serialVersionUID = 1L;
    private transient Morpheme morpheme;

    @Override
    public List<String> getPronunciations() {
        return this.morpheme == null ? null : this.morpheme.getPronunciations();
    }

    @Override
    public void setMorpheme(Morpheme morpheme) {
        this.morpheme = morpheme;
    }

    public void clear() {
        this.morpheme = null;
    }

    public void copyTo(AttributeImpl target) {
        PronunciationsAttribute t = (PronunciationsAttribute)target;
        t.setMorpheme(this.morpheme);
    }

    public void reflectWith(AttributeReflector reflector) {
        List<String> pronunciations = this.getPronunciations();
        List<String> enPronunciations = null;
        if (pronunciations != null) {
            String[] p = new String[pronunciations.size()];
            int i = 0;
            for (String kana : pronunciations) {
                p[i++] = ToStringUtil.getRomanization(kana);
            }
            enPronunciations = Arrays.asList(p);
        }
        reflector.reflect(PronunciationsAttribute.class, "pronunciations", pronunciations);
        reflector.reflect(PronunciationsAttribute.class, "pronunciations (en)", enPronunciations);
    }
}

