/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class DemoRule
extends Rule {
    @Override
    public String getId() {
        return "DEMO_RULE";
    }

    @Override
    public String getDescription() {
        return "A demo rule that just prints the text analysis";
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        AnalyzedTokenReadings[] tokens;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        for (AnalyzedTokenReadings token : tokens = sentence.getTokensWithoutWhitespace()) {
            System.out.println("Token: " + token.getToken());
            for (AnalyzedToken analyzedToken : token.getReadings()) {
                System.out.println("  Lemma: " + analyzedToken.getLemma());
                System.out.println("  POS: " + analyzedToken.getPOSTag());
            }
            if (!token.getToken().equals("demo")) continue;
            RuleMatch ruleMatch = new RuleMatch(this, sentence, token.getStartPos(), token.getEndPos(), "The demo rule thinks this looks wrong");
            ruleMatch.setSuggestedReplacement("blablah");
            ruleMatches.add(ruleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

