/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.sun.net.httpserver.HttpServer;
import java.net.InetSocketAddress;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import org.languagetool.JLanguageTool;
import org.languagetool.server.ErrorRequestLimiter;
import org.languagetool.server.HTTPSServer;
import org.languagetool.server.HTTPServerConfig;
import org.languagetool.server.LanguageToolHttpHandler;
import org.languagetool.server.PortBindingException;
import org.languagetool.server.RequestLimiter;
import org.languagetool.server.Server;
import org.languagetool.tools.Tools;

public class HTTPServer
extends Server {
    private final ExecutorService executorService;

    public HTTPServer() {
        this(new HTTPServerConfig());
    }

    public HTTPServer(HTTPServerConfig config) {
        this(config, false, DEFAULT_ALLOWED_IPS);
    }

    public HTTPServer(HTTPServerConfig config, boolean runInternally) {
        this(config, runInternally, "localhost", DEFAULT_ALLOWED_IPS);
    }

    public HTTPServer(HTTPServerConfig config, boolean runInternally, Set<String> allowedIps) {
        this(config, runInternally, "localhost", allowedIps);
    }

    public HTTPServer(HTTPServerConfig config, boolean runInternally, String host, Set<String> allowedIps) {
        this.port = config.getPort();
        this.host = host;
        try {
            InetSocketAddress address = host != null ? new InetSocketAddress(host, this.port) : new InetSocketAddress(this.port);
            this.server = HttpServer.create(address, 0);
            RequestLimiter limiter = this.getRequestLimiterOrNull(config);
            ErrorRequestLimiter errorLimiter = this.getErrorRequestLimiterOrNull(config);
            LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
            this.httpHandler = new LanguageToolHttpHandler(config, allowedIps, runInternally, limiter, errorLimiter, workQueue);
            this.server.createContext("/", this.httpHandler);
            this.executorService = this.getExecutorService(workQueue, config);
            this.server.setExecutor(this.executorService);
            if (config.getWarmUp()) {
                this.warmUp();
            }
        }
        catch (Exception e) {
            ResourceBundle messages = JLanguageTool.getMessageBundle();
            String message = Tools.i18n(messages, "http_server_start_failed", host, Integer.toString(this.port));
            throw new PortBindingException(message, e);
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    public static void main(String[] args) {
        if (args.length > 9 || HTTPServer.usageRequested(args)) {
            System.out.println("Usage: " + HTTPServer.class.getSimpleName() + " [--config propertyFile] [--port|-p port] [--public]");
            System.out.println("  --config FILE  a Java property file (one key=value entry per line) with values for:");
            HTTPServer.printCommonConfigFileOptions();
            HTTPServer.printCommonOptions();
            System.exit(1);
        }
        HTTPServerConfig config = new HTTPServerConfig(args);
        try {
            HTTPServer server;
            HTTPServer.checkForNonRootUser();
            System.out.println("WARNING: running in HTTP mode, consider using " + HTTPSServer.class.getName() + " for encrypted connections");
            if (config.isPublicAccess()) {
                System.out.println("WARNING: running in public mode, LanguageTool API can be accessed without restrictions!");
                server = new HTTPServer(config, false, null, null);
            } else {
                server = new HTTPServer(config, false, "localhost", DEFAULT_ALLOWED_IPS);
            }
            server.run();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start LanguageTool HTTP server on localhost, port " + config.getPort(), e);
        }
    }

    @Override
    protected String getProtocol() {
        return "http";
    }
}

