/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import java.awt.MenuComponent;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.openstreetmap.josm.actions.AddImageryLayerAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.MapRectifierWMSmenuAction;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.data.imagery.Shape;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.MenuScroller;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class ImageryMenu
extends JMenu
implements LayerManager.LayerChangeListener {
    public static final Comparator<ImageryInfo> alphabeticImageryComparator = (ii1, ii2) -> ii1.getName().toLowerCase(Locale.ENGLISH).compareTo(ii2.getName().toLowerCase(Locale.ENGLISH));
    private final transient Action offsetAction = new AdjustImageryOffsetAction();
    private final JMenuItem singleOffset;
    private JMenuItem offsetMenuItem = this.singleOffset = new JMenuItem(this.offsetAction);
    private final MapRectifierWMSmenuAction rectaction = new MapRectifierWMSmenuAction();
    private final List<Object> dynamicItems = new ArrayList<Object>(20);
    private final Map<ImageryInfo.ImageryCategory, List<JMenuItem>> dynamicNonPhotoItems = new EnumMap<ImageryInfo.ImageryCategory, List<JMenuItem>>(ImageryInfo.ImageryCategory.class);
    private final List<JMenuItem> dynamicNonPhotoMenus = new ArrayList<JMenuItem>(20);
    private final List<JosmAction> dynJosmActions = new ArrayList<JosmAction>(20);

    public ImageryMenu(JMenu subMenu) {
        super(I18n.trc("menu", "Imagery"));
        this.setupMenuScroller();
        MainApplication.getLayerManager().addLayerChangeListener(this);
        this.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                ImageryMenu.this.refreshImageryMenu();
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        MainMenu.add(subMenu, this.rectaction);
    }

    private void setupMenuScroller() {
        if (!GraphicsEnvironment.isHeadless()) {
            MenuScroller.setScrollerFor(this, 150, 2);
        }
    }

    private static boolean isPosInOneShapeIfAny(ImageryInfo info, LatLon pos) {
        List<Shape> shapes = info.getBounds().getShapes();
        return shapes == null || shapes.isEmpty() || shapes.stream().anyMatch(s -> s.contains(pos));
    }

    public void refreshImageryMenu() {
        this.removeDynamicItems();
        this.addDynamic(this.offsetMenuItem);
        this.addDynamicSeparator();
        ArrayList<ImageryInfo> savedLayers = new ArrayList<ImageryInfo>(ImageryLayerInfo.instance.getLayers());
        savedLayers.sort(alphabeticImageryComparator);
        for (ImageryInfo u : savedLayers) {
            this.addDynamic(this.trackJosmAction(new AddImageryLayerAction(u)), null);
        }
        if (MainApplication.isDisplayingMapView()) {
            MapView mv = MainApplication.getMap().mapView;
            LatLon pos = mv.getProjection().eastNorth2latlon(mv.getCenter());
            List<ImageryInfo> alreadyInUse = ImageryLayerInfo.instance.getLayers();
            List inViewLayers = ImageryLayerInfo.instance.getDefaultLayers().stream().filter(i -> i.getBounds() != null && i.getBounds().contains(pos) && !alreadyInUse.contains(i) && ImageryMenu.isPosInOneShapeIfAny(i, pos)).sorted(alphabeticImageryComparator).collect(Collectors.toList());
            if (!inViewLayers.isEmpty()) {
                if (inViewLayers.stream().anyMatch(i -> i.getImageryCategory() == ImageryInfo.ImageryCategory.PHOTO)) {
                    this.addDynamicSeparator();
                }
                for (ImageryInfo imageryInfo : inViewLayers) {
                    this.addDynamic(this.trackJosmAction(new AddImageryLayerAction(imageryInfo)), imageryInfo.getImageryCategory());
                }
            }
            if (!this.dynamicNonPhotoItems.isEmpty()) {
                this.addDynamicSeparator();
                for (Map.Entry entry : this.dynamicNonPhotoItems.entrySet()) {
                    ImageryInfo.ImageryCategory cat = (ImageryInfo.ImageryCategory)((Object)entry.getKey());
                    List list = (List)entry.getValue();
                    if (list.size() > 1) {
                        JMenu categoryMenu = new JMenu(cat.getDescription());
                        categoryMenu.setIcon(cat.getIcon(ImageProvider.ImageSizes.MENU));
                        for (JMenuItem it : list) {
                            ((Container)categoryMenu).add(it);
                        }
                        this.dynamicNonPhotoMenus.add(this.add(categoryMenu));
                        continue;
                    }
                    if (list.isEmpty()) continue;
                    this.dynamicNonPhotoMenus.add(this.add((JMenuItem)list.get(0)));
                }
            }
        }
        this.addDynamicSeparator();
        JMenu subMenu = MainApplication.getMenu().imagerySubMenu;
        int heightUnrolled = 30 * (this.getItemCount() + subMenu.getItemCount());
        if (heightUnrolled < MainApplication.getMainPanel().getHeight()) {
            int n = subMenu.getItemCount();
            for (int i3 = 0; i3 < n; ++i3) {
                this.addDynamic(subMenu.getItem(i3).getAction(), null);
            }
        } else {
            this.addDynamic(subMenu);
        }
    }

    private JMenuItem getNewOffsetMenu() {
        List<ImageryLayer> layers = MainApplication.getLayerManager().getLayersOfType(ImageryLayer.class);
        if (layers.isEmpty()) {
            this.offsetAction.setEnabled(false);
            return this.singleOffset;
        }
        this.offsetAction.setEnabled(true);
        JMenu newMenu = new JMenu(I18n.trc("layer", "Offset"));
        newMenu.setIcon(ImageProvider.get("mapmode", "adjustimg"));
        newMenu.setAction(this.offsetAction);
        if (layers.size() == 1) {
            return (JMenuItem)((ImageryLayer)layers.iterator().next()).getOffsetMenuItem(newMenu);
        }
        for (ImageryLayer layer : layers) {
            JMenuItem layerMenu = layer.getOffsetMenuItem();
            layerMenu.setText(layer.getName());
            layerMenu.setIcon(layer.getIcon());
            newMenu.add(layerMenu);
        }
        return newMenu;
    }

    public void refreshOffsetMenu() {
        this.offsetMenuItem = this.getNewOffsetMenu();
    }

    @Override
    public void layerAdded(LayerManager.LayerAddEvent e) {
        if (e.getAddedLayer() instanceof ImageryLayer) {
            this.refreshOffsetMenu();
        }
    }

    @Override
    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        if (e.getRemovedLayer() instanceof ImageryLayer) {
            this.refreshOffsetMenu();
        }
    }

    @Override
    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
        this.refreshOffsetMenu();
    }

    private void removeDynamicItems() {
        this.dynJosmActions.forEach(JosmAction::destroy);
        this.dynJosmActions.clear();
        this.dynamicItems.forEach(this::removeDynamicItem);
        this.dynamicItems.clear();
        this.dynamicNonPhotoMenus.forEach(this::removeDynamicItem);
        this.dynamicItems.clear();
        this.dynamicNonPhotoItems.clear();
    }

    private void removeDynamicItem(Object item) {
        if (item instanceof JMenuItem) {
            this.remove((JMenuItem)item);
        } else if (item instanceof MenuComponent) {
            this.remove((MenuComponent)item);
        } else if (item instanceof Component) {
            this.remove((Component)item);
        } else {
            Logging.error("Unknown imagery menu item type: {0}", item);
        }
    }

    private void addDynamicSeparator() {
        JPopupMenu.Separator s = new JPopupMenu.Separator();
        this.dynamicItems.add(s);
        this.add(s);
    }

    private void addDynamic(Action a, ImageryInfo.ImageryCategory category) {
        JMenuItem item = this.createActionComponent(a);
        item.setAction(a);
        this.doAddDynamic(item, category);
    }

    private void addDynamic(JMenuItem it) {
        this.doAddDynamic(it, null);
    }

    private void doAddDynamic(JMenuItem item, ImageryInfo.ImageryCategory category) {
        if (category == null || category == ImageryInfo.ImageryCategory.PHOTO) {
            this.dynamicItems.add(this.add(item));
        } else {
            this.dynamicNonPhotoItems.computeIfAbsent(category, x -> new ArrayList()).add(item);
        }
    }

    private Action trackJosmAction(Action action) {
        if (action instanceof JosmAction) {
            this.dynJosmActions.add((JosmAction)action);
        }
        return action;
    }

    static final class AdjustImageryOffsetAction
    extends JosmAction {
        AdjustImageryOffsetAction() {
            super(I18n.tr("Imagery offset", new Object[0]), "mapmode/adjustimg", I18n.tr("Adjust imagery offset", new Object[0]), null, false, false);
            this.setToolbarId("imagery-offset");
            MainApplication.getToolbar().register(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<ImageryLayer> layers = MainApplication.getLayerManager().getLayersOfType(ImageryLayer.class);
            if (layers.isEmpty()) {
                this.setEnabled(false);
                return;
            }
            Component source = null;
            if (e.getSource() instanceof Component) {
                source = (Component)e.getSource();
            }
            JPopupMenu popup = new JPopupMenu();
            if (layers.size() == 1) {
                JComponent c = ((ImageryLayer)layers.iterator().next()).getOffsetMenuItem(popup);
                if (c instanceof JMenuItem) {
                    ((JMenuItem)c).getAction().actionPerformed(e);
                } else {
                    if (source == null || !source.isShowing()) {
                        return;
                    }
                    popup.show(source, source.getWidth() / 2, source.getHeight() / 2);
                }
                return;
            }
            if (source == null || !source.isShowing()) {
                return;
            }
            for (ImageryLayer layer : layers) {
                JMenuItem layerMenu = layer.getOffsetMenuItem();
                layerMenu.setText(layer.getName());
                layerMenu.setIcon(layer.getIcon());
                popup.add(layerMenu);
            }
            popup.show(source, source.getWidth() / 2, source.getHeight() / 2);
        }
    }
}

