/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.I18n;

public class NameMismatch
extends Test.TagTest {
    protected static final int NAME_MISSING = 1501;
    protected static final int NAME_TRANSLATION_MISSING = 1502;
    private static final Pattern NAME_SPLIT_PATTERN = Pattern.compile(" - ");
    private static final List<String> EXCLUSIONS = Arrays.asList("name:botanical", "name:etymology:wikidata", "name:full", "name:genitive", "name:left", "name:prefix", "name:right", "name:source");

    public NameMismatch() {
        super(I18n.tr("Missing name:* translation", new Object[0]), I18n.tr("This test finds multilingual objects whose ''name'' attribute is not equal to some ''name:*'' attribute and not a composition of ''name:*'' attributes, e.g., Italia - Italien - Italy.", new Object[0]));
    }

    private void missingTranslation(OsmPrimitive p, String name) {
        this.errors.add(TestError.builder(this, Severity.OTHER, 1502).message(I18n.tr("Missing name:* translation", new Object[0]), I18n.marktr("Missing name:*={0}. Add tag with correct language key."), name).primitives(p).build());
    }

    @Override
    public void check(OsmPrimitive p) {
        if (!p.isTagged()) {
            return;
        }
        Set names = p.getKeys().entrySet().stream().filter(e -> e.getValue() != null && ((String)e.getKey()).startsWith("name:") && !EXCLUSIONS.contains(e.getKey())).map(Map.Entry::getValue).collect(Collectors.toSet());
        if (names.isEmpty()) {
            return;
        }
        String name = p.get("name");
        if (name == null) {
            this.errors.add(TestError.builder(this, Severity.OTHER, 1501).message(I18n.tr("A name is missing, even though name:* exists.", new Object[0])).primitives(p).build());
            return;
        }
        if (names.contains(name)) {
            return;
        }
        String[] splitNames = NAME_SPLIT_PATTERN.split(name);
        if (splitNames.length == 1) {
            this.missingTranslation(p, splitNames[0]);
            return;
        }
        for (String n : splitNames) {
            if (names.contains(n)) continue;
            this.missingTranslation(p, n);
        }
    }

    @Override
    public boolean isPrimitiveUsable(OsmPrimitive p) {
        return p.isTagged() && super.isPrimitiveUsable(p);
    }
}

