/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.io.OsmServerBackreferenceReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class DownloadReferrersTask
extends PleaseWaitRunnable {
    private boolean canceled;
    private Exception lastException;
    private OsmServerReader reader;
    private final OsmDataLayer targetLayer;
    private final Set<PrimitiveId> children;
    private final DataSet parents;

    public DownloadReferrersTask(OsmDataLayer targetLayer, Collection<? extends PrimitiveId> children) {
        super("Download referrers", false);
        CheckParameterUtil.ensureParameterNotNull(targetLayer, "targetLayer");
        if (!targetLayer.isDownloadable()) {
            throw new IllegalArgumentException("Non-downloadable layer: " + targetLayer);
        }
        this.canceled = false;
        this.children = new LinkedHashSet<PrimitiveId>();
        if (children != null) {
            children.stream().filter(p -> !p.isNew()).forEach(this.children::add);
        }
        this.targetLayer = targetLayer;
        this.parents = new DataSet();
    }

    public DownloadReferrersTask(OsmDataLayer targetLayer, PrimitiveId primitiveId, ProgressMonitor progressMonitor) {
        super("Download referrers", progressMonitor, false);
        CheckParameterUtil.ensureParameterNotNull(targetLayer, "targetLayer");
        if (primitiveId.isNew()) {
            throw new IllegalArgumentException(MessageFormat.format("Cannot download referrers for new primitives (ID {0})", primitiveId.getUniqueId()));
        }
        this.canceled = false;
        this.children = new LinkedHashSet<PrimitiveId>();
        this.children.add(primitiveId);
        this.targetLayer = targetLayer;
        this.parents = new DataSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        DownloadReferrersTask downloadReferrersTask = this;
        synchronized (downloadReferrersTask) {
            if (this.reader != null) {
                this.reader.cancel();
            }
        }
    }

    @Override
    protected void finish() {
        if (this.canceled) {
            return;
        }
        if (this.lastException != null) {
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), ExceptionUtil.explainException(this.lastException), I18n.tr("Error", new Object[0]), 0);
            return;
        }
        DataSetMerger visitor = new DataSetMerger(this.targetLayer.getDataSet(), this.parents);
        visitor.merge();
        SwingUtilities.invokeLater(this.targetLayer::onPostDownloadFromServer);
        if (visitor.getConflicts().isEmpty()) {
            return;
        }
        this.targetLayer.getConflicts().add(visitor.getConflicts());
        JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.trn("There was {0} conflict during import.", "There were {0} conflicts during import.", visitor.getConflicts().size(), visitor.getConflicts().size()), I18n.trn("Conflict during download", "Conflicts during download", visitor.getConflicts().size(), new Object[0]), 2);
        MapFrame map = MainApplication.getMap();
        map.conflictDialog.unfurlDialog();
        map.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadParents(long id, OsmPrimitiveType type, ProgressMonitor progressMonitor) throws OsmTransferException {
        this.reader = new OsmServerBackreferenceReader(id, type, false).setAllowIncompleteParentWays(true);
        DataSet ds = this.reader.parseOsm(progressMonitor.createSubTaskMonitor(1, false));
        DownloadReferrersTask downloadReferrersTask = this;
        synchronized (downloadReferrersTask) {
            this.reader = null;
            if (this.canceled) {
                return;
            }
        }
        new DataSetMerger(this.parents, ds).merge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        block13: {
            try {
                Set nodes;
                this.progressMonitor.setTicksCount(this.children.size());
                int i = 1;
                for (PrimitiveId p : this.children) {
                    String msg;
                    if (this.canceled) {
                        return;
                    }
                    String id = Long.toString(p.getUniqueId());
                    switch (p.getType()) {
                        case NODE: {
                            msg = I18n.tr("({0}/{1}) Loading parents of node {2}", i, this.children.size(), id);
                            break;
                        }
                        case WAY: {
                            msg = I18n.tr("({0}/{1}) Loading parents of way {2}", i, this.children.size(), id);
                            break;
                        }
                        case RELATION: {
                            msg = I18n.tr("({0}/{1}) Loading parents of relation {2}", i, this.children.size(), id);
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    this.progressMonitor.subTask(msg);
                    this.downloadParents(p.getUniqueId(), p.getType(), this.progressMonitor);
                    ++i;
                }
                Collection<Way> ways = this.parents.getWays();
                if (ways.isEmpty() || (nodes = ways.stream().flatMap(w -> w.getNodes().stream().filter(AbstractPrimitive::isIncomplete)).collect(Collectors.toSet())).isEmpty()) break block13;
                this.reader = MultiFetchServerObjectReader.create();
                ((MultiFetchServerObjectReader)this.reader).append(nodes);
                DataSet wayNodes = this.reader.parseOsm(this.progressMonitor.createSubTaskMonitor(1, false));
                DownloadReferrersTask downloadReferrersTask = this;
                synchronized (downloadReferrersTask) {
                    this.reader = null;
                }
                new DataSetMerger(this.parents, wayNodes).merge();
            }
            catch (OsmTransferException e) {
                if (this.canceled) {
                    return;
                }
                this.lastException = e;
            }
        }
    }
}

