/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openstreetmap.josm.actions.DownloadPrimitiveAction;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.animation.AnimationExtensionManager;
import org.openstreetmap.josm.gui.datatransfer.OpenTransferHandler;
import org.openstreetmap.josm.gui.dialogs.MenuItemSearchDialog;
import org.openstreetmap.josm.gui.preferences.server.ProxyPreference;
import org.openstreetmap.josm.gui.preferences.server.ProxyPreferenceListener;
import org.openstreetmap.josm.gui.widgets.JosmEditorPane;
import org.openstreetmap.josm.io.CacheCustomContent;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.WikiReader;

public final class GettingStarted
extends JPanel
implements ProxyPreferenceListener {
    private final LinkGeneral lg;
    private String content = "";
    private boolean contentInitialized;
    private final Timer timer = new Timer(50, e -> this.repaint());
    private static final String STYLE = "<style type=\"text/css\">\nbody {font-family: sans-serif; font-weight: bold; }\nh1 {text-align: center; }\n.icon {font-size: 0; }\n</style>\n";

    public GettingStarted() {
        super(new BorderLayout());
        this.lg = new LinkGeneral("<html><style type=\"text/css\">\nbody {font-family: sans-serif; font-weight: bold; }\nh1 {text-align: center; }\n.icon {font-size: 0; }\n</style>\n<h1>JOSM - " + I18n.tr("Java OpenStreetMap Editor", new Object[0]) + "</h1><h2 align=\"center\">" + I18n.tr("Downloading \"Message of the day\"", new Object[0]) + "</h2></html>");
        this.lg.getInputMap(0).put(DownloadPrimitiveAction.SHORTCUT.getKeyStroke(), "none");
        this.lg.getInputMap(0).put(MenuItemSearchDialog.Action.SHORTCUT.getKeyStroke(), "none");
        this.lg.setTransferHandler(null);
        JScrollPane scroller = new JScrollPane(this.lg);
        scroller.setViewportBorder(new EmptyBorder(10, 100, 10, 100));
        this.add((Component)scroller, "Center");
        this.getMOTD();
        this.setTransferHandler(new OpenTransferHandler());
    }

    @Override
    public void addNotify() {
        this.timer.start();
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        this.timer.stop();
        super.removeNotify();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.isShowing()) {
            AnimationExtensionManager.getExtension().adjustForSize(this.getWidth(), this.getHeight());
            AnimationExtensionManager.getExtension().animate();
            AnimationExtensionManager.getExtension().paint(g);
        }
    }

    private void getMOTD() {
        Thread t = new Thread(() -> {
            if (!this.contentInitialized && Config.getPref().getBoolean("help.displaymotd", true)) {
                try {
                    this.content = new MotdContent().updateIfRequiredString();
                    this.contentInitialized = true;
                    ProxyPreference.removeProxyPreferenceListener(this);
                }
                catch (IOException ex) {
                    Logging.log(Logging.LEVEL_WARN, I18n.tr("Failed to read MOTD. Exception was: {0}", ex.toString()), ex);
                    this.content = "<html><style type=\"text/css\">\nbody {font-family: sans-serif; font-weight: bold; }\nh1 {text-align: center; }\n.icon {font-size: 0; }\n</style>\n<h1>JOSM - " + I18n.tr("Java OpenStreetMap Editor", new Object[0]) + "</h1>\n<h2 align=\"center\">(" + I18n.tr("Message of the day not available", new Object[0]) + ")</h2></html>";
                    ProxyPreference.addProxyPreferenceListener(this);
                }
            }
            if (this.content != null) {
                EventQueue.invokeLater(() -> this.lg.setText(GettingStarted.fixImageLinks(this.content)));
            }
        }, "MOTD-Loader");
        t.setDaemon(true);
        t.start();
    }

    static String fixImageLinks(String s) {
        Matcher m = Pattern.compile("src=\"/browser/trunk/resources(/images/.*?\\.png)\\?format=raw\"").matcher(s);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String im = m.group(1);
            URL u = GettingStarted.class.getResource(im);
            if (u == null) continue;
            try {
                m.appendReplacement(sb, Matcher.quoteReplacement("src=\"" + Utils.betterJarUrl(u, u) + '\"'));
            }
            catch (IOException e) {
                Logging.error(e);
            }
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @Override
    public void proxyPreferenceChanged() {
        this.getMOTD();
    }

    static class MotdContent
    extends CacheCustomContent<IOException> {
        private final int myVersion = Version.getInstance().getVersion();
        private final String myJava = Utils.getSystemProperty("java.version");
        private final String myLang = LanguageInfo.getWikiLanguagePrefix();

        MotdContent() {
            super("motd.html", CacheCustomContent.INTERVAL_DAILY);
        }

        @Override
        protected byte[] updateData() throws IOException {
            String motd = new WikiReader().readLang("StartupPage");
            Config.getPref().putInt("cache.motd.html.version", this.myVersion);
            Config.getPref().put("cache.motd.html.java", this.myJava);
            Config.getPref().put("cache.motd.html.lang", this.myLang);
            return motd.getBytes(StandardCharsets.UTF_8);
        }

        @Override
        protected void checkOfflineAccess() {
            OnlineResource.JOSM_WEBSITE.checkOfflineAccess(new WikiReader().getBaseUrlWiki(), Config.getUrls().getJOSMWebsite());
        }

        @Override
        protected boolean isCacheValid() {
            return Config.getPref().getInt("cache.motd.html.version", -999) == this.myVersion && Config.getPref().get("cache.motd.html.java").equals(this.myJava) && Config.getPref().get("cache.motd.html.lang").equals(this.myLang);
        }
    }

    public static class LinkGeneral
    extends JosmEditorPane
    implements HyperlinkListener {
        public LinkGeneral(String text) {
            this.setContentType("text/html");
            this.setText(text);
            this.setEditable(false);
            this.setOpaque(false);
            this.addHyperlinkListener(this);
            LinkGeneral.adaptForNimbus(this);
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                OpenBrowser.displayUrl(e.getDescription());
            }
        }
    }
}

