/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets;

import java.awt.Component;
import java.awt.event.ActionEvent;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetSelector;
import org.openstreetmap.josm.tools.I18n;

public final class TaggingPresetSearchDialog
extends ExtendedDialog {
    private static TaggingPresetSearchDialog instance;
    private final TaggingPresetSelector selector;

    public static synchronized TaggingPresetSearchDialog getInstance() {
        if (instance == null) {
            instance = new TaggingPresetSearchDialog();
        }
        return instance;
    }

    private TaggingPresetSearchDialog() {
        super((Component)MainApplication.getMainFrame(), I18n.tr("Search presets", new Object[0]), I18n.tr("Select", new Object[0]), I18n.tr("Cancel", new Object[0]));
        this.setButtonIcons("dialogs/search", "cancel");
        this.configureContextsensitiveHelp("/Action/TaggingPresetSearch", true);
        this.selector = new TaggingPresetSelector(true, true);
        this.setContent(this.selector, false);
        SelectionEventManager.getInstance().addSelectionListener(this.selector);
        this.selector.setDblClickListener(e -> this.buttonAction(0, null));
    }

    @Override
    public ExtendedDialog showDialog() {
        this.selector.init();
        super.showDialog();
        this.selector.clearSelection();
        return this;
    }

    @Override
    protected void buttonAction(int buttonIndex, ActionEvent evt) {
        TaggingPreset preset;
        super.buttonAction(buttonIndex, evt);
        if (buttonIndex == 0 && (preset = this.selector.getSelectedPresetAndUpdateClassification()) != null) {
            preset.actionPerformed(null);
        }
        this.selector.savePreferences();
    }
}

