/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery.vectortile.mapbox.style;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public final class Expression {
    public static final Expression EMPTY_EXPRESSION = new Expression(JsonValue.NULL);
    private static final String EMPTY_STRING = "";
    private final String mapcssFilterExpression;

    public Expression(JsonValue value) {
        JsonArray array;
        this.mapcssFilterExpression = value.getValueType() == JsonValue.ValueType.ARRAY ? (!(array = value.asJsonArray()).isEmpty() && ((JsonValue)array.get(0)).getValueType() == JsonValue.ValueType.STRING ? ("==".equals(array.getString(0)) ? Expression.convertToString((JsonValue)array.get(1)) + "=" + Expression.convertToString((JsonValue)array.get(2)) : (Arrays.asList("<=", ">=", ">", "<", "!=").contains(array.getString(0)) ? Expression.convertToString((JsonValue)array.get(1)) + array.getString(0) + Expression.convertToString((JsonValue)array.get(2)) : EMPTY_STRING)) : EMPTY_STRING) : EMPTY_STRING;
    }

    private static String convertToString(JsonValue value) {
        switch (value.getValueType()) {
            case STRING: {
                return ((JsonString)value).getString();
            }
            case FALSE: {
                return Boolean.FALSE.toString();
            }
            case TRUE: {
                return Boolean.TRUE.toString();
            }
            case NUMBER: {
                return value.toString();
            }
            case ARRAY: {
                return '[' + ((JsonArray)value).stream().map(Expression::convertToString).collect(Collectors.joining(",")) + ']';
            }
            case OBJECT: {
                return '{' + ((JsonObject)value).entrySet().stream().map(entry -> (String)entry.getKey() + ":" + Expression.convertToString((JsonValue)entry.getValue())).collect(Collectors.joining(",")) + '}';
            }
        }
        return EMPTY_STRING;
    }

    public String toString() {
        return !EMPTY_STRING.equals(this.mapcssFilterExpression) ? '[' + this.mapcssFilterExpression + ']' : EMPTY_STRING;
    }

    public boolean equals(Object other) {
        if (other instanceof Expression) {
            Expression o = (Expression)other;
            return Objects.equals(this.mapcssFilterExpression, o.mapcssFilterExpression);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mapcssFilterExpression);
    }
}

