/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.util.Arrays;
import org.openstreetmap.josm.tools.Utils;

public final class ColorScale {
    private double min;
    private double max;
    private Color noDataColor;
    private Color belowMinColor;
    private Color aboveMaxColor;
    private Color[] colors;
    private String[] colorBarTitles;
    private String title = "";
    private int intervalCount = 5;

    private ColorScale() {
    }

    public static ColorScale createFixedScale(Color[] colors) {
        ColorScale sc = new ColorScale();
        sc.colors = Utils.copyArray(colors);
        sc.setRange(0.0, (double)colors.length - 1.0);
        sc.addBounds();
        return sc;
    }

    public static ColorScale createHSBScale(int count) {
        ColorScale sc = new ColorScale();
        sc.colors = new Color[count];
        for (int i = 0; i < count; ++i) {
            sc.colors[i] = Color.getHSBColor((float)i / 300.0f, 1.0f, 1.0f);
        }
        sc.setRange(0.0, 255.0);
        sc.addBounds();
        return sc;
    }

    public static ColorScale createCyclicScale(int count) {
        ColorScale sc = new ColorScale();
        int[] h = new int[]{0, 59, 127, 244, 360};
        int[] s = new int[]{100, 84, 99, 100};
        int[] b = new int[]{90, 93, 74, 83};
        sc.colors = new Color[count];
        for (int i = 0; i < sc.colors.length; ++i) {
            float angle = (float)i * 4.0f / (float)count;
            int quadrant = (int)angle;
            angle -= (float)quadrant;
            quadrant = Utils.mod(quadrant + 1, 4);
            float vh = (float)h[quadrant] * ColorScale.weighted(angle) + (float)h[quadrant + 1] * (1.0f - ColorScale.weighted(angle));
            float vs = (float)s[quadrant] * ColorScale.weighted(angle) + (float)s[Utils.mod(quadrant + 1, 4)] * (1.0f - ColorScale.weighted(angle));
            float vb = (float)b[quadrant] * ColorScale.weighted(angle) + (float)b[Utils.mod(quadrant + 1, 4)] * (1.0f - ColorScale.weighted(angle));
            sc.colors[i] = Color.getHSBColor(vh / 360.0f, vs / 100.0f, vb / 100.0f);
        }
        sc.setRange(0.0, Math.PI * 2);
        sc.addBounds();
        return sc;
    }

    private static float weighted(float x) {
        if ((double)x < 0.5) {
            return 1.0f - 2.0f * x * x;
        }
        return 2.0f * (1.0f - x) * (1.0f - x);
    }

    public void setRange(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public void addBounds() {
        this.aboveMaxColor = this.colors[this.colors.length - 1];
        this.belowMinColor = this.colors[0];
    }

    public Color getColor(double value) {
        if (value < this.min) {
            return this.belowMinColor;
        }
        if (value > this.max) {
            return this.aboveMaxColor;
        }
        if (Double.isNaN(value)) {
            return this.noDataColor;
        }
        int n = this.colors.length;
        int idx = (int)((value - this.min) * (double)this.colors.length / (this.max - this.min));
        if (idx < this.colors.length) {
            return this.colors[idx];
        }
        return this.colors[n - 1];
    }

    public Color getColor(Number value) {
        return value == null ? this.noDataColor : this.getColor(value.doubleValue());
    }

    public Color getNoDataColor() {
        return this.noDataColor;
    }

    public void setNoDataColor(Color noDataColor) {
        this.noDataColor = noDataColor;
    }

    public ColorScale makeTransparent(int alpha) {
        for (int i = 0; i < this.colors.length; ++i) {
            this.colors[i] = new Color(this.colors[i].getRGB() & 0xFFFFFF | (alpha & 0xFF) << 24, true);
        }
        return this;
    }

    public ColorScale addTitle(String title) {
        this.title = title;
        return this;
    }

    public ColorScale addColorBarTitles(String[] titles) {
        this.intervalCount = titles.length - 1;
        this.colorBarTitles = titles;
        return this;
    }

    public ColorScale setIntervalCount(int intervalCount) {
        this.intervalCount = intervalCount;
        return this;
    }

    public ColorScale makeReversed() {
        Color tmp;
        int n = this.colors.length;
        for (int i = 0; i < n / 2; ++i) {
            tmp = this.colors[i];
            this.colors[i] = this.colors[n - 1 - i];
            this.colors[n - 1 - i] = tmp;
        }
        tmp = this.belowMinColor;
        this.belowMinColor = this.aboveMaxColor;
        this.aboveMaxColor = tmp;
        return this;
    }

    public void drawColorBar(Graphics2D g, int x, int y, int w, int h, double valueScale) {
        int n = this.colors.length;
        for (int i = 0; i < n; ++i) {
            g.setColor(this.colors[i]);
            if (w < h) {
                g.fillRect(x, y + i * h / n, w, h / n + 1);
                continue;
            }
            g.fillRect(x + i * w / n, y, w / n + 1, h);
        }
        FontMetrics fm = g.getFontMetrics();
        int fh = fm.getHeight() / 2;
        int fw = this.colorBarTitles != null && this.colorBarTitles.length > 0 ? Arrays.asList(this.colorBarTitles).stream().mapToInt(title -> fm.stringWidth((String)title)).max().orElse(50) : fm.stringWidth(String.valueOf(Math.max((int)Math.abs(this.max * valueScale), (int)Math.abs(this.min * valueScale)))) + fm.stringWidth("0.123");
        g.setColor(this.noDataColor);
        if (this.title != null) {
            g.drawString(this.title, x - fw - 3, y - fh * 3 / 2);
        }
        for (int i = 0; i <= this.intervalCount; ++i) {
            String txt;
            g.setColor(this.colors[(int)(1.0 * (double)i * (double)n / (double)this.intervalCount - 1.0E-10)]);
            if (this.colorBarTitles != null && i < this.colorBarTitles.length) {
                txt = this.colorBarTitles[i];
            } else {
                double val = this.min + (double)i * (this.max - this.min) / (double)this.intervalCount;
                txt = String.format("%.3f", val * valueScale);
            }
            if (this.intervalCount == 0) {
                g.drawString(txt, x - fw - 3, y + h / 2 + fh / 2);
                continue;
            }
            if (w < h) {
                g.drawString(txt, x - fw - 3, y + i * h / this.intervalCount + fh / 2);
                continue;
            }
            g.drawString(txt, x + i * w / this.intervalCount - fw / 2, y + fh - 3);
        }
    }
}

