/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.ac;

import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.EventObject;
import java.util.regex.Pattern;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.text.AbstractDocument;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompComboBoxModel;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompEvent;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompListener;
import org.openstreetmap.josm.gui.tagging.ac.MaxLengthDocumentFilter;
import org.openstreetmap.josm.gui.util.CellEditorSupport;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.spi.preferences.Config;

public class AutoCompTextField<E>
extends JosmTextField
implements TableCellEditor,
KeyListener {
    private boolean autocompleteEnabled = true;
    private transient MaxLengthDocumentFilter docFilter;
    protected AutoCompComboBoxModel<E> model;
    private final boolean AUTOCOMPLETE_NUMBERS = !Config.getPref().getBoolean("autocomplete.dont_complete_numbers", true);
    private static final Pattern IS_NUMBER = Pattern.compile("^\\d+$");
    private transient CellEditorSupport tableCellEditorSupport;
    private String originalValue;

    protected final void init() {
        this.model = new AutoCompComboBoxModel();
        this.docFilter = new MaxLengthDocumentFilter();
        ((AbstractDocument)this.getDocument()).setDocumentFilter(this.docFilter);
        this.addKeyListener(this);
        this.tableCellEditorSupport = new CellEditorSupport(this);
    }

    public AutoCompTextField() {
        this(0);
    }

    public AutoCompTextField(AutoCompComboBoxModel<E> model) {
        this(0);
        this.model = model;
    }

    public AutoCompTextField(int columns) {
        this(columns, true);
    }

    public AutoCompTextField(int columns, boolean undoRedo) {
        super(null, null, columns, undoRedo);
        this.init();
    }

    public AutoCompComboBoxModel<E> getModel() {
        return this.model;
    }

    public void setModel(AutoCompComboBoxModel<E> model) {
        AutoCompComboBoxModel<E> oldModel = this.model;
        this.model = model;
        this.firePropertyChange("model", oldModel, model);
    }

    public final boolean isAutocompleteEnabled() {
        return this.autocompleteEnabled;
    }

    public boolean setAutocompleteEnabled(boolean enabled) {
        boolean oldEnabled = this.autocompleteEnabled;
        this.autocompleteEnabled = enabled;
        return oldEnabled;
    }

    public void setMaxTextLength(int length) {
        this.docFilter.setMaxLength(length);
    }

    private void autocomplete(String oldText) {
        String newText = this.getText();
        if (this.getSelectionEnd() != newText.length()) {
            return;
        }
        String unSelected = newText.substring(0, this.getSelectionStart());
        if (unSelected.length() <= oldText.length()) {
            return;
        }
        if (this.getInputMethodRequests().getCommittedTextLength() != this.getDocument().getLength()) {
            return;
        }
        if (!this.AUTOCOMPLETE_NUMBERS && IS_NUMBER.matcher(newText).matches()) {
            return;
        }
        this.fireAutoCompEvent(5900, null);
        E item = this.getModel().findBestCandidate(newText);
        this.fireAutoCompEvent(5901, item);
        if (item != null) {
            String text = item.toString();
            this.setText(text);
            this.select(newText.length(), text.length());
            this.copyToSysSel(text);
        }
    }

    void copyToSysSel(String s) {
        Clipboard sysSel = ClipboardUtils.getSystemSelection();
        if (sysSel != null) {
            StringSelection transferable = new StringSelection(s);
            sysSel.setContents(transferable, null);
        }
    }

    public synchronized void addAutoCompListener(AutoCompListener l) {
        this.listenerList.add(AutoCompListener.class, l);
    }

    public synchronized void removeAutoCompListener(AutoCompListener l) {
        this.listenerList.remove(AutoCompListener.class, l);
    }

    public synchronized AutoCompListener[] getAutoCompListeners() {
        return (AutoCompListener[])this.listenerList.getListeners(AutoCompListener.class);
    }

    protected void fireAutoCompEvent(int id, Object item) {
        Object[] listeners = this.listenerList.getListenerList();
        AutoCompEvent e = new AutoCompEvent(this, id, item);
        block4: for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != AutoCompListener.class) continue;
            switch (id) {
                case 5901: {
                    ((AutoCompListener)listeners[i + 1]).autoCompPerformed(e);
                    continue block4;
                }
                case 5900: {
                    ((AutoCompListener)listeners[i + 1]).autoCompBefore(e);
                    continue block4;
                }
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (this.autocompleteEnabled && this.getSelectionEnd() == this.getText().length()) {
            String oldText = this.getText().substring(0, this.getSelectionStart());
            SwingUtilities.invokeLater(() -> this.autocomplete(oldText));
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.tableCellEditorSupport.addCellEditorListener(l);
    }

    protected void rememberOriginalValue(String value) {
        this.originalValue = value;
    }

    protected void restoreOriginalValue() {
        this.setText(this.originalValue);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.tableCellEditorSupport.removeCellEditorListener(l);
    }

    @Override
    public void cancelCellEditing() {
        this.restoreOriginalValue();
        this.tableCellEditorSupport.fireEditingCanceled();
    }

    @Override
    public Object getCellEditorValue() {
        return this.getText();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.tableCellEditorSupport.fireEditingStopped();
        return true;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.setText(value == null ? "" : value.toString());
        this.rememberOriginalValue(this.getText());
        return this;
    }
}

