/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.tools.I18n;

public class DefaultLayer {
    private final String layerName;
    private final String tileMatrixSet;
    private final String style;

    public DefaultLayer(ImageryInfo.ImageryType imageryType, String layerName, String style, String tileMatrixSet) {
        this.layerName = layerName == null ? "" : layerName;
        String string = this.style = style == null ? "" : style;
        if (imageryType != ImageryInfo.ImageryType.WMTS && tileMatrixSet != null && !"".equals(tileMatrixSet)) {
            throw new IllegalArgumentException(I18n.tr("{0} imagery has tileMatrixSet defined to: {1}", imageryType, tileMatrixSet));
        }
        this.tileMatrixSet = tileMatrixSet == null ? "" : tileMatrixSet;
    }

    public String getLayerName() {
        return this.layerName;
    }

    public String getTileMatrixSet() {
        return this.tileMatrixSet;
    }

    public String getStyle() {
        return this.style;
    }

    public JsonObject toJson() {
        JsonObjectBuilder ret = Json.createObjectBuilder();
        ret.add("layerName", this.layerName);
        ret.add("style", this.style);
        ret.add("tileMatrixSet", this.tileMatrixSet);
        return ret.build();
    }

    public static DefaultLayer fromJson(JsonObject o, ImageryInfo.ImageryType type) {
        return new DefaultLayer(type, o.getString("layerName"), o.getString("style"), o.getString("tileMatrixSet"));
    }
}

