/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxConstants;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxExtension;
import org.openstreetmap.josm.data.gpx.GpxExtensionCollection;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.GpxRoute;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.IGpxTrack;
import org.openstreetmap.josm.data.gpx.IGpxTrackSegment;
import org.openstreetmap.josm.data.gpx.IWithAttributes;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class GpxWriter
extends XmlWriter
implements GpxConstants {
    private GpxData data;
    private String indent = "";
    private Instant metaTime;
    private List<String> validprefixes;
    private static final int WAY_POINT = 0;
    private static final int ROUTE_POINT = 1;
    private static final int TRACK_POINT = 2;

    public GpxWriter(PrintWriter out) {
        super(out);
    }

    public GpxWriter(OutputStream out) {
        super(new PrintWriter(new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8))));
    }

    public Instant getMetaTime() {
        return this.metaTime;
    }

    public void setMetaTime(Instant metaTime) {
        this.metaTime = metaTime;
    }

    public void write(GpxData data) {
        this.write(data, GpxConstants.ColorFormat.GPXD, true);
    }

    public void write(GpxData data, GpxConstants.ColorFormat colorFormat, boolean savePrefs) {
        this.data = data;
        data.beginUpdate();
        data.getTracks().stream().filter(GpxTrack.class::isInstance).map(GpxTrack.class::cast).forEach(trk -> trk.convertColor(colorFormat));
        data.getExtensions().removeAllWithPrefix("josm");
        if (data.fromServer) {
            data.getExtensions().add("josm", "from-server", "true");
        }
        if (savePrefs && !data.getLayerPrefs().isEmpty()) {
            GpxExtensionCollection layerExts = data.getExtensions().add("josm", "layerPreferences").getExtensions();
            data.getLayerPrefs().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
                GpxExtension e = layerExts.add("josm", "entry");
                e.put("key", entry.getKey());
                e.put("value", entry.getValue());
            });
        }
        data.put("meta.time", (this.metaTime != null ? this.metaTime : Instant.now()).toString(), false);
        data.endUpdate();
        ArrayList<IWithAttributes> all = new ArrayList<IWithAttributes>();
        all.add(data);
        all.addAll(data.getWaypoints());
        all.addAll(data.getRoutes());
        all.addAll(data.getTracks());
        all.addAll(data.getTrackSegmentsStream().collect(Collectors.toList()));
        List namespaces = all.stream().flatMap(w -> w.getExtensions().getPrefixesStream()).distinct().map(p -> data.getNamespaces().stream().filter(s -> s.getPrefix().equals(p)).findAny().orElse(GpxExtension.findNamespace(p))).filter(Objects::nonNull).collect(Collectors.toList());
        this.validprefixes = namespaces.stream().map(n -> n.getPrefix()).collect(Collectors.toList());
        data.creator = "JOSM GPX export";
        this.out.println("<?xml version='1.0' encoding='UTF-8'?>");
        this.out.print("<gpx version=\"1.1\" creator=\"");
        this.out.print("JOSM GPX export");
        this.out.println("\" xmlns=\"http://www.topografix.com/GPX/1/1\"");
        StringBuilder schemaLocations = new StringBuilder("http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd");
        for (GpxData.XMLNamespace n2 : namespaces) {
            if (n2.getURI() == null || Utils.isEmpty(n2.getPrefix())) continue;
            this.out.println(String.format("    xmlns:%s=\"%s\"", n2.getPrefix(), n2.getURI()));
            if (n2.getLocation() == null) continue;
            schemaLocations.append(' ').append(n2.getURI()).append(' ').append(n2.getLocation());
        }
        this.out.println("    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        this.out.println(String.format("    xsi:schemaLocation=\"%s\">", schemaLocations));
        this.indent = "  ";
        this.writeMetaData();
        this.writeWayPoints();
        this.writeRoutes();
        this.writeTracks();
        this.out.print("</gpx>");
        this.out.flush();
    }

    private void writeAttr(IWithAttributes obj, List<String> keys) {
        for (String key : keys) {
            if ("meta.links".equals(key)) {
                Collection lValue = obj.getCollection(key);
                if (lValue == null) continue;
                for (GpxLink link : lValue) {
                    this.gpxLink(link);
                }
                continue;
            }
            String value = obj.getString(key);
            if (value != null) {
                this.simpleTag(key, value);
                continue;
            }
            Object val = obj.get(key);
            if (val instanceof Date) {
                throw new IllegalStateException();
            }
            if (val instanceof Instant) {
                this.simpleTag(key, String.valueOf(val));
                continue;
            }
            if (val instanceof Number) {
                this.simpleTag(key, val.toString());
                continue;
            }
            if (val == null) continue;
            Logging.warn("GPX attribute '" + key + "' not managed: " + val);
        }
    }

    private void writeMetaData() {
        Bounds bounds;
        Map attr = this.data.attr;
        this.openln("metadata");
        if (attr.containsKey("meta.desc")) {
            this.simpleTag("desc", this.data.getString("meta.desc"));
        }
        if (attr.containsKey("meta.author.name") || attr.containsKey("meta.author.email")) {
            String[] tmp;
            this.openln("author");
            this.simpleTag("name", this.data.getString("meta.author.name"));
            if (attr.containsKey("meta.author.email") && (tmp = this.data.getString("meta.author.email").split("@", -1)).length == 2) {
                this.inline("email", "id=\"" + GpxWriter.encode(tmp[0]) + "\" domain=\"" + GpxWriter.encode(tmp[1]) + '\"');
            }
            this.gpxLink((GpxLink)this.data.get("meta.author.link"));
            this.closeln("author");
        }
        if (attr.containsKey("meta.copyright.license") || attr.containsKey("meta.copyright.year")) {
            this.openln("copyright", "author=\"" + GpxWriter.encode(this.data.get("meta.copyright.author").toString()) + '\"');
            if (attr.containsKey("meta.copyright.year")) {
                this.simpleTag("year", (String)this.data.get("meta.copyright.year"));
            }
            if (attr.containsKey("meta.copyright.license")) {
                this.simpleTag("license", GpxWriter.encode((String)this.data.get("meta.copyright.license")));
            }
            this.closeln("copyright");
        }
        if (attr.containsKey("meta.links")) {
            for (GpxLink link : this.data.getCollection("meta.links")) {
                this.gpxLink(link);
            }
        }
        if (attr.containsKey("meta.keywords")) {
            this.simpleTag("keywords", this.data.getString("meta.keywords"));
        }
        if (attr.containsKey("meta.time")) {
            this.simpleTag("time", this.data.getString("meta.time"));
        }
        if ((bounds = this.data.recalculateBounds()) != null) {
            String b = "minlat=\"" + bounds.getMinLat() + "\" minlon=\"" + bounds.getMinLon() + "\" maxlat=\"" + bounds.getMaxLat() + "\" maxlon=\"" + bounds.getMaxLon() + '\"';
            this.inline("bounds", b);
        }
        this.gpxExtensions(this.data.getExtensions());
        this.closeln("metadata");
    }

    private void writeWayPoints() {
        for (WayPoint pnt : this.data.getWaypoints()) {
            this.wayPoint(pnt, 0);
        }
    }

    private void writeRoutes() {
        for (GpxRoute rte : this.data.getRoutes()) {
            this.openln("rte");
            this.writeAttr(rte, RTE_TRK_KEYS);
            this.gpxExtensions(rte.getExtensions());
            for (WayPoint pnt : rte.routePoints) {
                this.wayPoint(pnt, 1);
            }
            this.closeln("rte");
        }
    }

    private void writeTracks() {
        for (IGpxTrack trk : this.data.getOrderedTracks()) {
            this.openln("trk");
            this.writeAttr(trk, RTE_TRK_KEYS);
            this.gpxExtensions(trk.getExtensions());
            for (IGpxTrackSegment seg : trk.getSegments()) {
                this.openln("trkseg");
                this.gpxExtensions(seg.getExtensions());
                for (WayPoint pnt : seg.getWayPoints()) {
                    this.wayPoint(pnt, 2);
                }
                this.closeln("trkseg");
            }
            this.closeln("trk");
        }
    }

    private void openln(String tag) {
        this.open(tag);
        this.out.println();
    }

    private void openln(String tag, String attributes) {
        this.open(tag, attributes);
        this.out.println();
    }

    private void open(String tag) {
        this.out.print(this.indent + '<' + tag + '>');
        this.indent = this.indent + "  ";
    }

    private void open(String tag, String attributes) {
        this.out.print(this.indent + '<' + tag + (attributes.isEmpty() ? "" : Character.valueOf(' ')) + attributes + '>');
        this.indent = this.indent + "  ";
    }

    private void inline(String tag, String attributes) {
        this.out.println(this.indent + '<' + tag + (attributes.isEmpty() ? "" : Character.valueOf(' ')) + attributes + "/>");
    }

    private void close(String tag) {
        this.indent = this.indent.substring(2);
        this.out.print(this.indent + "</" + tag + '>');
    }

    private void closeln(String tag) {
        this.close(tag);
        this.out.println();
    }

    private void simpleTag(String tag, String content) {
        if (!Utils.isEmpty(content)) {
            this.open(tag);
            this.out.print(GpxWriter.encode(content));
            this.out.println("</" + tag + '>');
            this.indent = this.indent.substring(2);
        }
    }

    private void simpleTag(String tag, String content, String attributes) {
        if (!Utils.isEmpty(content)) {
            this.open(tag, attributes);
            this.out.print(GpxWriter.encode(content));
            this.out.println("</" + tag + '>');
            this.indent = this.indent.substring(2);
        }
    }

    private void gpxLink(GpxLink link) {
        if (link != null) {
            this.openln("link", "href=\"" + GpxWriter.encode(link.uri) + '\"');
            this.simpleTag("text", link.text);
            this.simpleTag("type", link.type);
            this.closeln("link");
        }
    }

    private void wayPoint(WayPoint pnt, int mode) {
        String type;
        switch (mode) {
            case 0: {
                type = "wpt";
                break;
            }
            case 1: {
                type = "rtept";
                break;
            }
            case 2: {
                type = "trkpt";
                break;
            }
            default: {
                throw new JosmRuntimeException(I18n.tr("Unknown mode {0}.", mode));
            }
        }
        if (pnt != null) {
            LatLon c = pnt.getCoor();
            String coordAttr = "lat=\"" + c.lat() + "\" lon=\"" + c.lon() + '\"';
            if (pnt.attr.isEmpty() && pnt.getExtensions().isEmpty()) {
                this.inline(type, coordAttr);
            } else {
                this.openln(type, coordAttr);
                this.writeAttr(pnt, WPT_KEYS);
                this.gpxExtensions(pnt.getExtensions());
                this.closeln(type);
            }
        }
    }

    private void gpxExtensions(GpxExtensionCollection allExtensions) {
        if (allExtensions.isVisible()) {
            this.openln("extensions");
            this.writeExtension(allExtensions);
            this.closeln("extensions");
        }
    }

    private void writeExtension(List<GpxExtension> extensions) {
        for (GpxExtension e : extensions) {
            if (!this.validprefixes.contains(e.getPrefix()) || !e.isVisible()) continue;
            String k = (e.getPrefix().isEmpty() ? "" : e.getPrefix() + ":") + e.getKey();
            String attr = e.getAttributes().entrySet().stream().map(a -> GpxWriter.encode((String)a.getKey()) + "=\"" + GpxWriter.encode(a.getValue().toString()) + "\"").sorted().collect(Collectors.joining(" "));
            if (e.getValue() == null && e.getExtensions().isEmpty()) {
                this.inline(k, attr);
                continue;
            }
            if (e.getExtensions().isEmpty()) {
                this.simpleTag(k, e.getValue(), attr);
                continue;
            }
            this.openln(k, attr);
            if (e.getValue() != null) {
                this.out.print(GpxWriter.encode(e.getValue()));
            }
            this.writeExtension(e.getExtensions());
            this.closeln(k);
        }
    }
}

