/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.downloadtasks.DownloadParams;
import org.openstreetmap.josm.data.osm.DownloadPolicy;
import org.openstreetmap.josm.data.osm.UploadPolicy;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

public abstract class RequestHandler {
    public static final BooleanProperty GLOBAL_CONFIRMATION = new BooleanProperty("remotecontrol.always-confirm", false);
    public static final BooleanProperty LOAD_IN_NEW_LAYER = new BooleanProperty("remotecontrol.new-layer", false);
    public static final IntegerProperty OSM_DOWNLOAD_TIMEOUT = new IntegerProperty("remotecontrol.osm.download.timeout", 300);
    protected static final Pattern SPLITTER_COMMA = Pattern.compile(",\\s*");
    protected static final Pattern SPLITTER_SEMIC = Pattern.compile(";\\s*");
    protected static final PermissionCache PERMISSIONS = new PermissionCache();
    protected Map<String, String> args;
    protected String request;
    protected String content = "OK\r\n";
    protected String contentType = "text/plain";
    protected String myCommand;
    protected String sender;

    public final void handle() throws RequestHandlerForbiddenException, RequestHandlerBadRequestException, RequestHandlerErrorException {
        this.checkMandatoryParams();
        this.validateRequest();
        this.checkPermission();
        this.handleRequest();
    }

    protected abstract void validateRequest() throws RequestHandlerBadRequestException;

    protected abstract void handleRequest() throws RequestHandlerErrorException, RequestHandlerBadRequestException;

    public abstract String getPermissionMessage();

    public abstract PermissionPrefWithDefault getPermissionPref();

    public abstract String[] getMandatoryParams();

    public String[] getOptionalParams() {
        return new String[0];
    }

    public String getUsage() {
        return null;
    }

    public String[] getUsageExamples() {
        return new String[0];
    }

    public String[] getUsageExamples(String cmd) {
        return this.getUsageExamples();
    }

    public final void checkPermission() throws RequestHandlerForbiddenException {
        PermissionPrefWithDefault permissionPref = this.getPermissionPref();
        if (permissionPref != null && permissionPref.pref != null && !Config.getPref().getBoolean(permissionPref.pref, permissionPref.defaultVal)) {
            String err = MessageFormat.format("RemoteControl: ''{0}'' forbidden by preferences", this.myCommand);
            Logging.info(err);
            throw new RequestHandlerForbiddenException(err);
        }
        if (PERMISSIONS.isAllowed(this.myCommand, this.sender)) {
            return;
        }
        if (GLOBAL_CONFIRMATION.get().booleanValue()) {
            Integer maxWidth = (int)Math.max(200.0, (double)MainApplication.getMainFrame().getWidth() * 0.6);
            String message = "<html><div>" + this.getPermissionMessage() + "<br/>" + I18n.tr("Do you want to allow this?", new Object[0]) + "</div></html>";
            JLabel label = new JLabel(message);
            if (label.getPreferredSize().width > maxWidth) {
                label.setText(message.replaceFirst("<div>", "<div style=\"width:" + maxWidth + "px;\">"));
            }
            Object[] choices = new Object[]{I18n.tr("Yes, always", new Object[0]), I18n.tr("Yes, once", new Object[0]), I18n.tr("No", new Object[0])};
            int choice = JOptionPane.showOptionDialog(MainApplication.getMainFrame(), label, I18n.tr("Confirm Remote Control action", new Object[0]), 1, 3, null, choices, choices[1]);
            if (choice != 0 && choice != 1) {
                String err = MessageFormat.format("RemoteControl: ''{0}'' forbidden by user''s choice", this.myCommand);
                throw new RequestHandlerForbiddenException(err);
            }
            if (choice == 0) {
                PERMISSIONS.allow(this.myCommand, this.sender);
            }
        }
    }

    public void setUrl(String url) throws RequestHandlerBadRequestException {
        this.request = url;
        try {
            this.parseArgs();
        }
        catch (URISyntaxException e) {
            throw new RequestHandlerBadRequestException(e);
        }
    }

    protected void parseArgs() throws URISyntaxException {
        this.args = RequestHandler.getRequestParameter(new URI(this.request));
    }

    protected final String[] splitArg(String arg, Pattern splitter) {
        return splitter.split(this.args != null ? (CharSequence)this.args.get(arg) : "", -1);
    }

    static Map<String, String> getRequestParameter(URI uri) {
        HashMap<String, String> r = new HashMap<String, String>();
        if (uri.getRawQuery() == null) {
            return r;
        }
        for (String kv : uri.getRawQuery().split("&", -1)) {
            String[] kvs = Utils.decodeUrl(kv).split("=", 2);
            r.put(kvs[0], kvs.length > 1 ? kvs[1] : null);
        }
        return r;
    }

    void checkMandatoryParams() throws RequestHandlerBadRequestException {
        String[] mandatory = this.getMandatoryParams();
        String[] optional = this.getOptionalParams();
        LinkedList<String> missingKeys = new LinkedList<String>();
        boolean error = false;
        if (mandatory != null && this.args != null) {
            for (String key : mandatory) {
                String value = this.args.get(key);
                if (value != null && !value.isEmpty()) continue;
                error = true;
                Logging.warn('\'' + this.myCommand + "' remote control request must have '" + key + "' parameter");
                missingKeys.add(key);
            }
        }
        HashSet knownParams = new HashSet();
        if (mandatory != null) {
            Collections.addAll(knownParams, mandatory);
        }
        if (optional != null) {
            Collections.addAll(knownParams, optional);
        }
        if (this.args != null) {
            for (String par : this.args.keySet()) {
                if (knownParams.contains(par)) continue;
                Logging.warn("Unknown remote control parameter {0}, skipping it", par);
            }
        }
        if (error) {
            throw new RequestHandlerBadRequestException(I18n.tr("The following keys are mandatory, but have not been provided: {0}", String.join((CharSequence)", ", missingKeys)));
        }
    }

    public void setCommand(String command) {
        if (command.charAt(0) == '/') {
            command = command.substring(1);
        }
        this.myCommand = command;
    }

    public String getCommand() {
        return this.myCommand;
    }

    public String getContent() {
        return this.content;
    }

    public String getContentType() {
        return this.contentType;
    }

    private <T> T get(String key, Function<String, T> parser, Supplier<T> defaultSupplier) {
        String val = this.args.get(key);
        return val != null && !val.isEmpty() ? parser.apply(val) : defaultSupplier.get();
    }

    private boolean get(String key) {
        return this.get(key, Boolean::parseBoolean, () -> Boolean.FALSE);
    }

    private boolean isLoadInNewLayer() {
        return this.get("new_layer", Boolean::parseBoolean, LOAD_IN_NEW_LAYER::get);
    }

    protected DownloadParams getDownloadParams() {
        DownloadParams result = new DownloadParams();
        if (this.args != null) {
            result = result.withNewLayer(this.isLoadInNewLayer()).withLayerName(this.args.get("layer_name")).withLocked(this.get("layer_locked")).withDownloadPolicy(this.get("download_policy", DownloadPolicy::of, () -> DownloadPolicy.NORMAL)).withUploadPolicy(this.get("upload_policy", UploadPolicy::of, () -> UploadPolicy.NORMAL));
        }
        return result;
    }

    protected void validateDownloadParams() throws RequestHandlerBadRequestException {
        try {
            this.getDownloadParams();
        }
        catch (IllegalArgumentException e) {
            throw new RequestHandlerBadRequestException(e);
        }
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public static class RequestHandlerForbiddenException
    extends RequestHandlerException {
        public RequestHandlerForbiddenException(String message) {
            super(message);
        }
    }

    static class PermissionCache {
        private final Set<Pair<String, String>> allowed = new HashSet<Pair<String, String>>();

        PermissionCache() {
        }

        public void allow(String command, String sender) {
            this.allowed.add(Pair.create(command, sender));
        }

        public boolean isAllowed(String command, String sender) {
            return this.allowed.contains(Pair.create(command, sender));
        }

        public void clear() {
            this.allowed.clear();
        }
    }

    public static class RequestHandlerBadRequestException
    extends RequestHandlerException {
        public RequestHandlerBadRequestException(String message) {
            super(message);
        }

        public RequestHandlerBadRequestException(Throwable cause) {
            super(cause);
        }

        public RequestHandlerBadRequestException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static abstract class RawURLParseRequestHandler
    extends RequestHandler {
        @Override
        protected void parseArgs() throws URISyntaxException {
            HashMap<String, String> args = new HashMap<String, String>();
            if (this.request.indexOf(63) != -1) {
                String query = this.request.substring(this.request.indexOf(63) + 1);
                if (query.indexOf("url=") == 0) {
                    args.put("url", Utils.decodeUrl(query.substring(4)));
                } else {
                    String[] params;
                    int urlIdx = query.indexOf("&url=");
                    if (urlIdx != -1) {
                        args.put("url", Utils.decodeUrl(query.substring(urlIdx + 5)));
                        query = query.substring(0, urlIdx);
                    } else if (query.indexOf(35) != -1) {
                        query = query.substring(0, query.indexOf(35));
                    }
                    for (String param : params = query.split("&", -1)) {
                        int eq = param.indexOf(61);
                        if (eq == -1) continue;
                        args.put(param.substring(0, eq), Utils.decodeUrl(param.substring(eq + 1)));
                    }
                }
            }
            this.args = args;
        }
    }

    public static class RequestHandlerOsmApiException
    extends RequestHandlerErrorException {
        public RequestHandlerOsmApiException(OsmApiException cause) {
            super(cause);
        }
    }

    public static class RequestHandlerErrorException
    extends RequestHandlerException {
        public RequestHandlerErrorException(String message) {
            super(message);
        }

        public RequestHandlerErrorException(Throwable cause) {
            super(cause);
        }
    }

    public static class RequestHandlerException
    extends Exception {
        public RequestHandlerException(String message) {
            super(message);
        }

        public RequestHandlerException(String message, Throwable cause) {
            super(message, cause);
        }

        public RequestHandlerException(Throwable cause) {
            super(cause);
        }
    }
}

