/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker;
import org.openstreetmap.josm.data.validation.tests.MapCSSTagCheckerRule;
import org.openstreetmap.josm.gui.mappaint.mapcss.ConditionFactory;
import org.openstreetmap.josm.gui.mappaint.mapcss.ExpressionFactory;
import org.openstreetmap.josm.gui.mappaint.mapcss.LiteralExpression;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.tools.DefaultGeoProperty;
import org.openstreetmap.josm.tools.GeoProperty;
import org.openstreetmap.josm.tools.GeoPropertyIndex;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Territories;

final class MapCSSTagCheckerAsserts {
    private static final ArrayList<MapCSSTagCheckerRule> previousChecks = new ArrayList();

    private MapCSSTagCheckerAsserts() {
    }

    static void checkAsserts(MapCSSTagCheckerRule check, Map<String, Boolean> assertions, MapCSSTagChecker.AssertionConsumer assertionConsumer) {
        DataSet ds = new DataSet();
        Logging.debug("Check: {0}", check);
        for (Map.Entry<String, Boolean> i : assertions.entrySet()) {
            Command fix;
            Logging.debug("- Assertion: {0}", i);
            OsmPrimitive p = OsmUtils.createPrimitive(i.getKey(), MapCSSTagCheckerAsserts.getLocation(check), true);
            ArrayList<Set<MapCSSTagCheckerRule>> checksToRun = new ArrayList<Set<MapCSSTagCheckerRule>>();
            Set<MapCSSTagCheckerRule> checkDependencies = MapCSSTagCheckerAsserts.getTagCheckDependencies(check, previousChecks);
            if (!checkDependencies.isEmpty()) {
                checksToRun.add(checkDependencies);
            }
            checksToRun.add(Collections.singleton(check));
            MapCSSTagCheckerAsserts.addPrimitive(ds, p);
            Collection<TestError> pErrors = MapCSSTagChecker.getErrorsForPrimitive(p, true, checksToRun);
            Logging.debug("- Errors: {0}", pErrors);
            boolean isError = pErrors.stream().anyMatch(e -> e.getTester() instanceof MapCSSTagChecker.MapCSSTagCheckerAndRule && ((MapCSSTagChecker.MapCSSTagCheckerAndRule)e.getTester()).rule.equals(check.rule));
            if (isError != i.getValue()) {
                assertionConsumer.accept(MessageFormat.format("Expecting test ''{0}'' (i.e., {1}) to {2} {3} (i.e., {4})", check.getMessage(p), check.rule.selectors, i.getValue() != false ? "match" : "not match", i.getKey(), p.getKeys()));
            }
            if (isError && (fix = check.fixPrimitive(p)) != null && fix.executeCommand() && !MapCSSTagChecker.getErrorsForPrimitive(p, true, checksToRun).isEmpty()) {
                assertionConsumer.accept(MessageFormat.format("Autofix does not work for test ''{0}'' (i.e., {1})", check.getMessage(p), check.rule.selectors));
            }
            ds.removePrimitive((PrimitiveId)p);
        }
        previousChecks.add(check);
    }

    public static void clear() {
        previousChecks.clear();
        previousChecks.trimToSize();
    }

    private static void addPrimitive(DataSet ds, OsmPrimitive p) {
        if (p instanceof Way) {
            ((Way)p).getNodes().forEach(n -> MapCSSTagCheckerAsserts.addPrimitive(ds, n));
        } else if (p instanceof Relation) {
            ((Relation)p).getMembers().forEach(m -> MapCSSTagCheckerAsserts.addPrimitive(ds, m.getMember()));
        }
        ds.addPrimitive(p);
    }

    private static LatLon getLocation(MapCSSTagCheckerRule check) {
        GeoProperty<Boolean> prop;
        GeoPropertyIndex<Boolean> index;
        Optional<String> inside = MapCSSTagCheckerAsserts.getFirstInsideCountry(check);
        if (inside.isPresent() && (index = Territories.getGeoPropertyIndex(inside.get())) != null && (prop = index.getGeoProperty()) instanceof DefaultGeoProperty) {
            return ((DefaultGeoProperty)prop).getRandomLatLon();
        }
        return LatLon.ZERO;
    }

    private static Optional<String> getFirstInsideCountry(MapCSSTagCheckerRule check) {
        return check.rule.selectors.stream().filter(s -> s instanceof Selector.GeneralSelector).flatMap(s -> ((Selector.GeneralSelector)s).getConditions().stream()).filter(c -> c instanceof ConditionFactory.ExpressionCondition).map(c -> ((ConditionFactory.ExpressionCondition)c).getExpression()).filter(c -> c instanceof ExpressionFactory.IsInsideFunction).map(c -> (ExpressionFactory.IsInsideFunction)c).map(ExpressionFactory.IsInsideFunction::getArg).filter(e -> e instanceof LiteralExpression).map(e -> ((LiteralExpression)e).getLiteral()).filter(l -> l instanceof String).map(l -> ((String)l).split(",", -1)[0]).findFirst();
    }

    private static Set<MapCSSTagCheckerRule> getTagCheckDependencies(MapCSSTagCheckerRule check, Collection<MapCSSTagCheckerRule> schecks) {
        HashSet<MapCSSTagCheckerRule> result = new HashSet<MapCSSTagCheckerRule>();
        Set classes = check.rule.selectors.stream().filter(s -> s instanceof Selector.AbstractSelector).flatMap(s -> ((Selector.AbstractSelector)s).getConditions().stream()).filter(c -> c instanceof ConditionFactory.ClassCondition).map(c -> ((ConditionFactory.ClassCondition)c).id).collect(Collectors.toSet());
        if (schecks != null && !classes.isEmpty()) {
            return schecks.stream().filter(tc -> !check.equals(tc)).filter(tc -> tc.setClassExpressions.stream().anyMatch(classes::contains)).collect(Collectors.toSet());
        }
        return result;
    }
}

