/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import shared.b;
import shared.generic;
import shared.ignore;
import shared.nested;
import shared.readexception;
import shared.uncaughtexception;

public abstract class IBytestream {
    private HashMap<String, Object> _context = new HashMap();
    public String sourceName = "";

    public abstract byte readByte();

    public abstract byte[] readBytes(int var1);

    public abstract int readInt();

    public abstract short readShort();

    public abstract int getAbsoluteOffset();

    public abstract int getFilelength();

    public abstract int getBytesRemaining();

    public abstract IBytestream Fork(long var1);

    protected abstract int read();

    public boolean areBytesKnownToBeAvailable() {
        return this.getBytesRemaining() != 0;
    }

    public InputStream getChildStreamIfExists() {
        return null;
    }

    public void set(String keyname, Object value) {
        this._context.put(keyname, value);
    }

    public Object getValue(String keyname) {
        return this._context.get(keyname);
    }

    public int getIntValue(String keyname) {
        return (Integer)this.getValue(keyname);
    }

    public String getStringValue(String keyname) {
        return (String)this.getValue(keyname);
    }

    public void skip(long n) {
        for (long i = 0L; i < n; ++i) {
            this.readByte();
        }
    }

    public long readLong() {
        long i0 = b.Int32ToInt64(this.readInt());
        long i1 = b.Int32ToInt64(this.readInt());
        long r = i1 << 32 | i0 << 0;
        return r;
    }

    public float readFloat() {
        int data = this.readInt();
        float result = Float.intBitsToFloat(data);
        return result;
    }

    public float[] readFloats(int num) {
        float[] result = new float[num];
        for (int i = 0; i < num; ++i) {
            result[i] = this.readFloat();
        }
        return result;
    }

    public int[] readInts(int num) {
        int[] result = new int[num];
        for (int i = 0; i < num; ++i) {
            result[i] = this.readInt();
        }
        return result;
    }

    public short[] readShorts(int num) {
        short[] result = new short[num];
        for (int i = 0; i < num; ++i) {
            result[i] = this.readShort();
        }
        return result;
    }

    public void close() {
    }

    public IBytestream Fork() {
        return this.Fork(this.getAbsoluteOffset());
    }

    public <T> Vector<T> readVector(Class<T> objclass, int size) {
        Vector<T> result = new Vector<T>();
        for (int i = 0; i < size; ++i) {
            result.add(this.readObj(objclass));
        }
        return result;
    }

    public <T> ArrayList<T> readArrayList(Class<T> objclass, int size) {
        ArrayList<T> result = new ArrayList<T>();
        for (int i = 0; i < size; ++i) {
            result.add(this.readObj(objclass));
        }
        return result;
    }

    public <T> T[] readArray(Class<T> objclass, int size) {
        T[] result = generic.makeArray(objclass, size);
        for (int i = 0; i < size; ++i) {
            result[i] = this.readObj(objclass);
        }
        return result;
    }

    <T> Constructor findIBytestreamConstructor(Class<T> objclass) throws NoSuchMethodException {
        for (Constructor<?> constructor : objclass.getConstructors()) {
            Class<?>[] args = constructor.getParameterTypes();
            if (args.length != 1 || !IBytestream.class.isAssignableFrom(args[0])) continue;
            return constructor;
        }
        throw new NoSuchMethodException();
    }

    public <T> T readObj(Class<T> objclass) {
        try {
            return this.findIBytestreamConstructor(objclass).newInstance(this);
        }
        catch (NoSuchMethodException e2) {
            throw new nested(e2);
        }
        catch (InstantiationException e3) {
            throw new nested(e3);
        }
        catch (IllegalAccessException e4) {
            throw new nested(e4);
        }
        catch (InvocationTargetException e5) {
            Throwable e2 = e5.getCause();
            if (e2 instanceof readexception) {
                e2.printStackTrace();
                throw new uncaughtexception("Encountered readexception.");
            }
            if (e2 instanceof ignore) {
                throw (ignore)e2;
            }
            e2.printStackTrace();
            throw new nested(e5);
        }
    }

    public byte[][] readMultiDimensionBytes(int num1, int num2) {
        byte[][] result = new byte[num1][];
        for (int i = 0; i < num1; ++i) {
            result[i] = this.readBytes(num2);
        }
        return result;
    }

    public int[][] readMultiDimensionInts(int num1, int num2) {
        int[][] result = new int[num1][];
        for (int i = 0; i < num1; ++i) {
            result[i] = this.readInts(num2);
        }
        return result;
    }

    public short readShortBigEndian() {
        int b1 = this.read();
        int b2 = this.read();
        short result = (short)(b1 << 8 | b2);
        return result;
    }

    public int readIntBigEndian() {
        int b1 = this.read();
        int b2 = this.read();
        int b3 = this.read();
        int b4 = this.read();
        int result = b1 << 24 | b2 << 16 | b3 << 8 | b4;
        return result;
    }

    public int readIntAsTwoShorts() {
        short s1 = this.readShort();
        short s2 = this.readShort();
        int r = (s1 & 0xFFFF) << 16 | (s2 & 0xFFFF) << 0;
        return r;
    }
}

