/*
 * Decompiled with CFR 0.152.
 */
package dust.com.sun.java.swing.plaf.motif;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicDesktopPaneUI;

public class MotifDesktopPaneUI
extends BasicDesktopPaneUI {
    public static ComponentUI createUI(JComponent d) {
        return new MotifDesktopPaneUI();
    }

    @Override
    protected void installDesktopManager() {
        this.desktopManager = this.desktop.getDesktopManager();
        if (this.desktopManager == null) {
            this.desktopManager = new MotifDesktopManager();
            this.desktop.setDesktopManager(this.desktopManager);
            ((MotifDesktopManager)this.desktopManager).adjustIcons(this.desktop);
        }
    }

    public Insets getInsets(JComponent c) {
        return new Insets(0, 0, 0, 0);
    }

    private class MotifDesktopManager
    extends DefaultDesktopManager
    implements Serializable,
    UIResource {
        JComponent dragPane;
        boolean usingDragPane = false;
        private transient JLayeredPane layeredPaneForDragPane;
        int iconWidth;
        int iconHeight;

        private MotifDesktopManager() {
        }

        @Override
        public void setBoundsForFrame(JComponent f, int newX, int newY, int newWidth, int newHeight) {
            if (!this.usingDragPane) {
                boolean didResize = f.getWidth() != newWidth || f.getHeight() != newHeight;
                Rectangle r = f.getBounds();
                f.setBounds(newX, newY, newWidth, newHeight);
                SwingUtilities.computeUnion(newX, newY, newWidth, newHeight, r);
                f.getParent().repaint(r.x, r.y, r.width, r.height);
                if (didResize) {
                    f.validate();
                }
            } else {
                Rectangle r = this.dragPane.getBounds();
                this.dragPane.setBounds(newX, newY, newWidth, newHeight);
                SwingUtilities.computeUnion(newX, newY, newWidth, newHeight, r);
                this.dragPane.getParent().repaint(r.x, r.y, r.width, r.height);
            }
        }

        @Override
        public void beginDraggingFrame(JComponent f) {
            this.usingDragPane = false;
            if (f.getParent() instanceof JLayeredPane) {
                if (this.dragPane == null) {
                    this.dragPane = new DragPane();
                }
                this.layeredPaneForDragPane = (JLayeredPane)f.getParent();
                this.layeredPaneForDragPane.setLayer(this.dragPane, Integer.MAX_VALUE);
                this.dragPane.setBounds(f.getX(), f.getY(), f.getWidth(), f.getHeight());
                this.layeredPaneForDragPane.add(this.dragPane);
                this.usingDragPane = true;
            }
        }

        @Override
        public void dragFrame(JComponent f, int newX, int newY) {
            this.setBoundsForFrame(f, newX, newY, f.getWidth(), f.getHeight());
        }

        @Override
        public void endDraggingFrame(JComponent f) {
            if (this.usingDragPane) {
                this.layeredPaneForDragPane.remove(this.dragPane);
                this.usingDragPane = false;
                if (f instanceof JInternalFrame) {
                    this.setBoundsForFrame(f, this.dragPane.getX(), this.dragPane.getY(), this.dragPane.getWidth(), this.dragPane.getHeight());
                } else if (f instanceof JInternalFrame.JDesktopIcon) {
                    this.adjustBoundsForIcon((JInternalFrame.JDesktopIcon)f, this.dragPane.getX(), this.dragPane.getY());
                }
            }
        }

        @Override
        public void beginResizingFrame(JComponent f, int direction) {
            this.usingDragPane = false;
            if (f.getParent() instanceof JLayeredPane) {
                if (this.dragPane == null) {
                    this.dragPane = new DragPane();
                }
                JLayeredPane p = (JLayeredPane)f.getParent();
                p.setLayer(this.dragPane, Integer.MAX_VALUE);
                this.dragPane.setBounds(f.getX(), f.getY(), f.getWidth(), f.getHeight());
                p.add(this.dragPane);
                this.usingDragPane = true;
            }
        }

        @Override
        public void resizeFrame(JComponent f, int newX, int newY, int newWidth, int newHeight) {
            this.setBoundsForFrame(f, newX, newY, newWidth, newHeight);
        }

        @Override
        public void endResizingFrame(JComponent f) {
            if (this.usingDragPane) {
                JLayeredPane p = (JLayeredPane)f.getParent();
                p.remove(this.dragPane);
                this.usingDragPane = false;
                this.setBoundsForFrame(f, this.dragPane.getX(), this.dragPane.getY(), this.dragPane.getWidth(), this.dragPane.getHeight());
            }
        }

        @Override
        public void iconifyFrame(JInternalFrame f) {
            JInternalFrame.JDesktopIcon icon = f.getDesktopIcon();
            Point p = icon.getLocation();
            this.adjustBoundsForIcon(icon, p.x, p.y);
            super.iconifyFrame(f);
        }

        protected void adjustIcons(JDesktopPane desktop) {
            JInternalFrame.JDesktopIcon icon = new JInternalFrame.JDesktopIcon(new JInternalFrame());
            Dimension iconSize = icon.getPreferredSize();
            this.iconWidth = iconSize.width;
            this.iconHeight = iconSize.height;
            JInternalFrame[] frames = desktop.getAllFrames();
            for (int i = 0; i < frames.length; ++i) {
                icon = frames[i].getDesktopIcon();
                Point ip = icon.getLocation();
                this.adjustBoundsForIcon(icon, ip.x, ip.y);
            }
        }

        protected void adjustBoundsForIcon(JInternalFrame.JDesktopIcon icon, int x, int y) {
            JDesktopPane c = icon.getDesktopPane();
            int maxy = c.getHeight();
            int w = this.iconWidth;
            int h = this.iconHeight;
            c.repaint(x, y, w, h);
            x = x < 0 ? 0 : x;
            y = y < 0 ? 0 : y;
            y = y >= maxy ? maxy - 1 : y;
            int lx = x / w * w;
            int ygap = maxy % h;
            int ly = (y - ygap) / h * h + ygap;
            int dx = x - lx;
            int dy = y - ly;
            int n = x = dx < w / 2 ? lx : lx + w;
            int n2 = dy < h / 2 ? ly : (y = ly + h < maxy ? ly + h : ly);
            while (this.getIconAt(c, icon, x, y) != null) {
                x += w;
            }
            if (x > c.getWidth()) {
                return;
            }
            if (icon.getParent() != null) {
                this.setBoundsForFrame(icon, x, y, w, h);
            } else {
                icon.setLocation(x, y);
            }
        }

        protected JInternalFrame.JDesktopIcon getIconAt(JDesktopPane desktop, JInternalFrame.JDesktopIcon icon, int x, int y) {
            Object currentIcon = null;
            Component[] components = desktop.getComponents();
            for (int i = 0; i < components.length; ++i) {
                Component comp = components[i];
                if (!(comp instanceof JInternalFrame.JDesktopIcon) || comp == icon) continue;
                Point p = comp.getLocation();
                if (p.x != x || p.y != y) continue;
                return (JInternalFrame.JDesktopIcon)comp;
            }
            return null;
        }
    }

    private class DragPane
    extends JComponent {
        private DragPane() {
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(Color.darkGray);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
    }
}

