/*
 * Decompiled with CFR 0.152.
 */
package auto.inplace;

import auto.AllGames;
import auto.inplace.InplaceFile;
import auto.inplace.Inplace_Cleft;
import auto.inplace.Inplace_Fanages;
import auto.inplace.Inplace_Misc;
import auto.inplace.Inplace_city;
import java.util.HashMap;
import prpobjects.PrpRootObject;
import prpobjects.Typeid;
import prpobjects.Uruobjectref;
import prpobjects.plRelevanceRegion;
import prpobjects.prpfile;
import prpobjects.sumfile;
import shared.CryptHashes;
import shared.b;
import shared.m;

public class Inplace {
    public static ModName getModName(String modname) {
        return ModName.valueOf(modname);
    }

    public static void printAllModNames() {
        for (ModName modname : ModName.values()) {
            m.msg(modname.toString());
        }
    }

    public static void InplaceMod(String potsfolder, String relpath, String modname) {
        if (!AllGames.getPots().isFolderX(potsfolder)) {
            m.cancel();
        }
        InplaceFile pots2 = new InplaceFile(potsfolder);
        InplaceModInfo info = new InplaceModInfo();
        info.relpath = relpath;
        info.modnames = new ModName[]{Inplace.getModName(modname)};
        info.age = AllGames.getPots().GetAgenameFromPrpname(relpath);
        Inplace.InplaceMod(pots2, info);
    }

    public static void InplaceMod(InplaceFile potsfolder, String relpath) {
        Inplace.InplaceMod(potsfolder, InplaceModInfo.get(relpath));
    }

    public static void InplaceMod(InplaceFile potsfolder, InplaceModInfo info) {
        InplaceFile f = potsfolder.File(info.relpath);
        byte[] data = f.ReadAsBytes();
        prpfile prp = prpfile.createFromBytes(data, true);
        boolean waschanged = true;
        for (ModName modname : info.modnames) {
            if (modname == ModName.RemoveFence) {
                Inplace_Cleft.RemoveFence(info, prp);
                continue;
            }
            if (modname == ModName.FixKadishDoors) {
                Inplace_city.FixKadishDoors(info, prp);
                continue;
            }
            if (modname == ModName.RemoveRelevanceRegions) {
                PrpRootObject[] relregs;
                for (PrpRootObject relreg : relregs = prp.FindAllObjectsOfType(Typeid.plRelevanceRegion)) {
                    plRelevanceRegion rr = (plRelevanceRegion)relreg.castTo();
                    Uruobjectref r1 = rr.ref;
                    Uruobjectref r2 = rr.parent.ref;
                    prp.markObjectDeleted(relreg.getref(), false);
                    prp.markObjectDeleted(r1, false);
                    prp.markObjectDeleted(r2, false);
                    boolean bl = false;
                }
                continue;
            }
            if (modname == ModName.CityBalconyMarkerFix) {
                Inplace_city.CityBalconyMarkerFix(info, prp);
                continue;
            }
            if (modname == ModName.CityMuseumDoorFix) {
                Inplace_city.CityMuseumDoorFix(info, prp);
                continue;
            }
            if (modname == ModName.MakeTeledahnIntoKirelBook) {
                Inplace_city.MakeTeledahnInfoKirelBook(info, prp);
                continue;
            }
            if (modname == ModName.FixGeostates) {
                Inplace_Fanages.FixGeostates(info, prp);
                continue;
            }
            if (modname == ModName.AhnonayTranslation) {
                String actualmd5 = b.BytesToHexString(CryptHashes.GetMd5(data));
                if (Inplace_Misc.TranslateAhny(info, prp, actualmd5)) continue;
                waschanged = false;
                continue;
            }
            if (modname == ModName.ReltoFixPineTree) {
                if (Inplace_Misc.ReltoFixPineTree(info, prp)) continue;
                waschanged = false;
                continue;
            }
            if (modname == ModName.ReltoMakeDynamicCovers) {
                if (Inplace_Misc.ReltoMakeDynamicCovers(info, prp)) continue;
                waschanged = false;
                continue;
            }
            if (modname == ModName.GahreesenWallSoundFix) {
                Inplace_Misc.GahreesenWallSoundFix(info, prp);
                continue;
            }
            m.err("Unable to find modname: " + modname.toString());
        }
        if (waschanged) {
            f.SaveFile(prp.saveAsBytes());
            Inplace.UpdateSumfile(potsfolder, info);
        }
    }

    public static void UpdateSumfile(InplaceFile potsfolder, InplaceModInfo info) {
        InplaceFile sumfile2 = potsfolder.File("/dat/" + info.age + ".sum");
        if (sumfile2.exists()) {
            byte[] sumdata = sumfile.createEmptySumfile().getByteArray();
            sumfile2.SaveFile(sumdata);
        }
    }

    public static class InplaceModInfo {
        public String relpath;
        public ModName[] modnames;
        public String age;
        private static HashMap<String, InplaceModInfo> mods;

        private InplaceModInfo() {
        }

        private static HashMap<String, InplaceModInfo> getmods() {
            if (mods == null) {
                mods = new HashMap();
                InplaceModInfo.addinfo("Cleft", "/dat/Cleft_District_Desert.prp", ModName.RemoveFence);
                InplaceModInfo.addinfo("Cleft", "/dat/Cleft_District_tmnaDesert.prp", ModName.RemoveFence);
                InplaceModInfo.addinfo("city", "/dat/city_District_palace.prp", ModName.RemoveRelevanceRegions, ModName.CityBalconyMarkerFix, ModName.FixKadishDoors);
                InplaceModInfo.addinfo("city", "/dat/city_District_courtyard.prp", ModName.RemoveRelevanceRegions, ModName.CityMuseumDoorFix, ModName.FixKadishDoors, ModName.MakeTeledahnIntoKirelBook);
                InplaceModInfo.addinfo("city", "/dat/city_District_canyon.prp", ModName.RemoveRelevanceRegions, ModName.FixKadishDoors);
                InplaceModInfo.addinfo("city", "/dat/city_District_cavetjunction.prp", ModName.RemoveRelevanceRegions);
                InplaceModInfo.addinfo("city", "/dat/city_District_ferry.prp", ModName.RemoveRelevanceRegions);
                InplaceModInfo.addinfo("city", "/dat/city_District_greatstair.prp", ModName.RemoveRelevanceRegions);
                InplaceModInfo.addinfo("city", "/dat/city_District_KadishGallery.prp", ModName.RemoveRelevanceRegions, ModName.FixKadishDoors);
                InplaceModInfo.addinfo("city", "/dat/city_District_KahloPub.prp", ModName.RemoveRelevanceRegions);
                InplaceModInfo.addinfo("city", "/dat/city_District_library.prp", ModName.RemoveRelevanceRegions, ModName.FixKadishDoors);
                InplaceModInfo.addinfo("city", "/dat/city_District_harbor.prp", ModName.FixKadishDoors);
                InplaceModInfo.addinfo("AhnySphere01", "/dat/AhnySphere01_District_Sphere01.prp", ModName.AhnonayTranslation);
                InplaceModInfo.addinfo("AhnySphere01", "/dat/AhnySphere01_District_MaintRoom01.prp", ModName.AhnonayTranslation);
                InplaceModInfo.addinfo("AhnySphere01", "/dat/AhnySphere01_District_Sphere01OutBuildingInterior.prp", ModName.AhnonayTranslation);
                InplaceModInfo.addinfo("Personal", "/dat/Personal_District_psnlMYSTII.prp", ModName.ReltoFixPineTree, ModName.ReltoMakeDynamicCovers);
                InplaceModInfo.addinfo("Garrison", "/dat/Garrison_District_WallRoom.prp", ModName.GahreesenWallSoundFix);
            }
            return mods;
        }

        private static void addinfo(String age, String relpath, ModName ... modnames) {
            InplaceModInfo r = new InplaceModInfo();
            r.age = age;
            r.relpath = relpath;
            r.modnames = modnames;
            mods.put(relpath, r);
        }

        public static InplaceModInfo get(String relpath) {
            InplaceModInfo r = InplaceModInfo.getmods().get(relpath);
            return r;
        }
    }

    public static enum ModName {
        RemoveFence,
        FixKadishDoors,
        RemoveRelevanceRegions,
        CityBalconyMarkerFix,
        CityMuseumDoorFix,
        MakeTeledahnIntoKirelBook,
        AhnonayTranslation,
        ReltoFixPineTree,
        ReltoMakeDynamicCovers,
        GahreesenWallSoundFix,
        FixGeostates;

    }
}

