/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Archive.SevenZip;

import SevenZip.Archive.Common.BindPair;
import SevenZip.Archive.Common.CoderMixer2;
import SevenZip.Archive.Common.CoderMixer2ST;
import SevenZip.Archive.Common.CoderStreamsInfo;
import SevenZip.Archive.Common.FilterCoder;
import SevenZip.Archive.SevenZip.AltCoderInfo;
import SevenZip.Archive.SevenZip.BindInfoEx;
import SevenZip.Archive.SevenZip.CoderInfo;
import SevenZip.Archive.SevenZip.Folder;
import SevenZip.Archive.SevenZip.MethodID;
import SevenZip.Compression.Branch.BCJ2_x86_Decoder;
import SevenZip.Compression.Branch.BCJ_x86_Decoder;
import SevenZip.ICompressCoder;
import SevenZip.ICompressCoder2;
import SevenZip.ICompressProgressInfo;
import SevenZip.ICompressSetDecoderProperties2;
import SevenZip.IInStream;
import SevenZipCommon.ByteBuffer;
import SevenZipCommon.LimitedSequentialInStream;
import SevenZipCommon.LockedInStream;
import SevenZipCommon.LockedSequentialInStreamImp;
import SevenZipCommon.LongVector;
import SevenZipCommon.ObjectVector;
import SevenZipCommon.RecordVector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Decoder {
    boolean _bindInfoExPrevIsDefined;
    BindInfoEx _bindInfoExPrev;
    boolean _multiThread;
    CoderMixer2ST _mixerCoderSTSpec;
    CoderMixer2 _mixerCoderCommon;
    ICompressCoder2 _mixerCoder;
    ObjectVector<Object> _decoders;

    public Decoder(boolean multiThread) {
        this._multiThread = multiThread;
        this._bindInfoExPrevIsDefined = false;
        this._bindInfoExPrev = new BindInfoEx();
        this._mixerCoder = null;
        this._decoders = new ObjectVector();
    }

    static void ConvertFolderItemInfoToBindInfo(Folder folder, BindInfoEx bindInfo) {
        int i;
        bindInfo.Clear();
        for (int i2 = 0; i2 < folder.BindPairs.size(); ++i2) {
            BindPair bindPair = new BindPair();
            bindPair.InIndex = ((BindPair)folder.BindPairs.get((int)i2)).InIndex;
            bindPair.OutIndex = ((BindPair)folder.BindPairs.get((int)i2)).OutIndex;
            bindInfo.BindPairs.add(bindPair);
        }
        int outStreamIndex = 0;
        for (i = 0; i < folder.Coders.size(); ++i) {
            CoderStreamsInfo coderStreamsInfo = new CoderStreamsInfo();
            CoderInfo coderInfo = (CoderInfo)folder.Coders.get(i);
            coderStreamsInfo.NumInStreams = coderInfo.NumInStreams;
            coderStreamsInfo.NumOutStreams = coderInfo.NumOutStreams;
            bindInfo.Coders.add(coderStreamsInfo);
            AltCoderInfo altCoderInfo = coderInfo.AltCoders.Front();
            bindInfo.CoderMethodIDs.add(altCoderInfo.MethodID);
            int j = 0;
            while (j < coderStreamsInfo.NumOutStreams) {
                if (folder.FindBindPairForOutStream(outStreamIndex) < 0) {
                    bindInfo.OutStreams.add(outStreamIndex);
                }
                ++j;
                ++outStreamIndex;
            }
        }
        for (i = 0; i < folder.PackStreams.size(); ++i) {
            bindInfo.InStreams.add(folder.PackStreams.get(i));
        }
    }

    static boolean AreCodersEqual(CoderStreamsInfo a1, CoderStreamsInfo a2) {
        return a1.NumInStreams == a2.NumInStreams && a1.NumOutStreams == a2.NumOutStreams;
    }

    static boolean AreBindPairsEqual(BindPair a1, BindPair a2) {
        return a1.InIndex == a2.InIndex && a1.OutIndex == a2.OutIndex;
    }

    static boolean AreBindInfoExEqual(BindInfoEx a1, BindInfoEx a2) {
        int i;
        if (a1.Coders.size() != a2.Coders.size()) {
            return false;
        }
        for (i = 0; i < a1.Coders.size(); ++i) {
            if (Decoder.AreCodersEqual((CoderStreamsInfo)a1.Coders.get(i), (CoderStreamsInfo)a2.Coders.get(i))) continue;
            return false;
        }
        if (a1.BindPairs.size() != a2.BindPairs.size()) {
            return false;
        }
        for (i = 0; i < a1.BindPairs.size(); ++i) {
            if (Decoder.AreBindPairsEqual((BindPair)a1.BindPairs.get(i), (BindPair)a2.BindPairs.get(i))) continue;
            return false;
        }
        for (i = 0; i < a1.CoderMethodIDs.size(); ++i) {
            if (a1.CoderMethodIDs.get(i) == a2.CoderMethodIDs.get(i)) continue;
            return false;
        }
        if (a1.InStreams.size() != a2.InStreams.size()) {
            return false;
        }
        return a1.OutStreams.size() == a2.OutStreams.size();
    }

    public int Decode(IInStream inStream, long startPos, LongVector packSizes, int packSizesOffset, Folder folderInfo, OutputStream outStream, ICompressProgressInfo compressProgress) throws IOException {
        int i;
        boolean createNewCoders;
        ObjectVector<LimitedSequentialInStream> inStreams = new ObjectVector<LimitedSequentialInStream>();
        LockedInStream lockedInStream = new LockedInStream();
        lockedInStream.Init(inStream);
        for (int j = 0; j < folderInfo.PackStreams.size(); ++j) {
            LimitedSequentialInStream streamSpec;
            LockedSequentialInStreamImp lockedStreamImpSpec;
            LockedSequentialInStreamImp lockedStreamImp = lockedStreamImpSpec = new LockedSequentialInStreamImp();
            lockedStreamImpSpec.Init(lockedInStream, startPos);
            startPos += packSizes.get(j + packSizesOffset);
            LimitedSequentialInStream inStream2 = streamSpec = new LimitedSequentialInStream();
            streamSpec.SetStream(lockedStreamImp);
            streamSpec.Init(packSizes.get(j + packSizesOffset));
            inStreams.add(inStream2);
        }
        int numCoders = folderInfo.Coders.size();
        BindInfoEx bindInfo = new BindInfoEx();
        Decoder.ConvertFolderItemInfoToBindInfo(folderInfo, bindInfo);
        if (!this._bindInfoExPrevIsDefined) {
            createNewCoders = true;
        } else {
            boolean bl = createNewCoders = !Decoder.AreBindInfoExEqual(bindInfo, this._bindInfoExPrev);
        }
        if (createNewCoders) {
            this._decoders.clear();
            if (this._mixerCoder != null) {
                this._mixerCoder.close();
            }
            if (this._multiThread) {
                throw new IOException("multithreaded decoder not implemented");
            }
            this._mixerCoderSTSpec = new CoderMixer2ST();
            this._mixerCoder = this._mixerCoderSTSpec;
            this._mixerCoderCommon = this._mixerCoderSTSpec;
            this._mixerCoderCommon.SetBindInfo(bindInfo);
            for (int i2 = 0; i2 < numCoders; ++i2) {
                Object decoder;
                CoderInfo coderInfo = (CoderInfo)folderInfo.Coders.get(i2);
                AltCoderInfo altCoderInfo = coderInfo.AltCoders.Front();
                if (coderInfo.IsSimpleCoder()) {
                    decoder = null;
                    BCJ_x86_Decoder filter = null;
                    if (altCoderInfo.MethodID.equals(MethodID.k_LZMA)) {
                        decoder = new SevenZip.Compression.LZMA.Decoder();
                    }
                    if (altCoderInfo.MethodID.equals(MethodID.k_PPMD)) {
                        System.out.println("PPMD not implemented");
                    }
                    if (altCoderInfo.MethodID.equals(MethodID.k_BCJ_X86)) {
                        filter = new BCJ_x86_Decoder();
                    }
                    if (altCoderInfo.MethodID.equals(MethodID.k_Deflate)) {
                        System.out.println("DEFLATE not implemented");
                    }
                    if (altCoderInfo.MethodID.equals(MethodID.k_BZip2)) {
                        System.out.println("BZIP2 not implemented");
                    }
                    if (altCoderInfo.MethodID.equals(MethodID.k_Copy)) {
                        decoder = new SevenZip.Compression.Copy.Decoder();
                    }
                    if (altCoderInfo.MethodID.equals(MethodID.k_7zAES)) {
                        throw new IOException("k_7zAES not implemented");
                    }
                    if (filter != null) {
                        FilterCoder coderSpec = new FilterCoder();
                        decoder = coderSpec;
                        coderSpec.Filter = filter;
                    }
                    if (decoder == null) {
                        return -2147467263;
                    }
                    this._decoders.add(decoder);
                    if (this._multiThread) {
                        throw new IOException("Multithreaded decoder is not implemented");
                    }
                    this._mixerCoderSTSpec.AddCoder((ICompressCoder)decoder, false);
                    continue;
                }
                decoder = null;
                if (altCoderInfo.MethodID.equals(MethodID.k_BCJ2)) {
                    decoder = new BCJ2_x86_Decoder();
                }
                if (decoder == null) {
                    return -2147467263;
                }
                this._decoders.add(decoder);
                if (this._multiThread) {
                    throw new IOException("Multithreaded decoder is not implemented");
                }
                this._mixerCoderSTSpec.AddCoder2((ICompressCoder2)decoder, false);
            }
            this._bindInfoExPrev = bindInfo;
            this._bindInfoExPrevIsDefined = true;
        }
        this._mixerCoderCommon.ReInit();
        int packStreamIndex = 0;
        int unPackStreamIndex = 0;
        int coderIndex = 0;
        for (i = 0; i < numCoders; ++i) {
            CoderInfo coderInfo = (CoderInfo)folderInfo.Coders.get(i);
            AltCoderInfo altCoderInfo = coderInfo.AltCoders.Front();
            Object decoder = this._decoders.get(coderIndex);
            try {
                boolean ret;
                ICompressSetDecoderProperties2 setDecoderProperties = (ICompressSetDecoderProperties2)decoder;
                ByteBuffer properties = altCoderInfo.Properties;
                int size = properties.GetCapacity();
                if (size == -1) {
                    return -2147467263;
                }
                if (size > 0 && !(ret = setDecoderProperties.SetDecoderProperties2(properties.data()))) {
                    return -2147467259;
                }
            }
            catch (ClassCastException setDecoderProperties) {
                // empty catch block
            }
            ++coderIndex;
            int numInStreams = coderInfo.NumInStreams;
            int numOutStreams = coderInfo.NumOutStreams;
            LongVector packSizesPointers = new LongVector();
            LongVector unPackSizesPointers = new LongVector();
            packSizesPointers.Reserve(numInStreams);
            unPackSizesPointers.Reserve(numOutStreams);
            int j = 0;
            while (j < numOutStreams) {
                unPackSizesPointers.add(folderInfo.UnPackSizes.get(unPackStreamIndex));
                ++j;
                ++unPackStreamIndex;
            }
            j = 0;
            while (j < numInStreams) {
                int bindPairIndex = folderInfo.FindBindPairForInStream(packStreamIndex);
                if (bindPairIndex >= 0) {
                    packSizesPointers.add(folderInfo.UnPackSizes.get(((BindPair)folderInfo.BindPairs.get((int)bindPairIndex)).OutIndex));
                } else {
                    int index = folderInfo.FindPackStreamArrayIndex(packStreamIndex);
                    if (index < 0) {
                        return -2147467259;
                    }
                    packSizesPointers.add(packSizes.get(index));
                }
                ++j;
                ++packStreamIndex;
            }
            this._mixerCoderCommon.SetCoderInfo(i, packSizesPointers, unPackSizesPointers);
        }
        int[] temp_useless = new int[1];
        int[] tmp1 = new int[1];
        bindInfo.FindOutStream(bindInfo.OutStreams.get(0), tmp1, temp_useless);
        int mainCoder = tmp1[0];
        if (this._multiThread) {
            throw new IOException("Multithreaded decoder is not implemented");
        }
        if (numCoders == 0) {
            return 0;
        }
        RecordVector<InputStream> inStreamPointers = new RecordVector<InputStream>();
        inStreamPointers.Reserve(inStreams.size());
        for (i = 0; i < inStreams.size(); ++i) {
            inStreamPointers.add((InputStream)inStreams.get(i));
        }
        RecordVector<OutputStream> outStreamPointer = new RecordVector<OutputStream>();
        outStreamPointer.add(outStream);
        return this._mixerCoder.Code(inStreamPointers, null, inStreams.size(), outStreamPointer, null, 1, compressProgress);
    }
}

