/*
 * Decompiled with CFR 0.152.
 */
package pythondec;

import java.util.Arrays;
import pythondec.PyObject;
import shared.IBytedeque;
import shared.IBytestream;
import shared.b;

public class PyString
extends PyObject {
    public int n;
    public byte[] rawstr;

    public PyString(IBytestream c) {
        this.n = c.readInt();
        this.rawstr = c.readBytes(this.n);
    }

    private PyString() {
    }

    public String toString() {
        return "PyString: " + b.BytesToString(this.rawstr);
    }

    public String toJavaString() {
        return b.BytesToString(this.rawstr);
    }

    public static PyString create(String s) {
        return PyString.create(b.StringToBytes(s));
    }

    public static PyString create(byte[] data) {
        PyString r = new PyString();
        r.rawstr = data;
        r.n = r.rawstr.length;
        return r;
    }

    public void marshal(IBytedeque c) {
        c.writeByte((byte)115);
        c.writeInt(this.n);
        c.writeBytes(this.rawstr);
    }

    public int hashCode() {
        return Arrays.hashCode(this.rawstr);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof PyString)) {
            return false;
        }
        PyString o2 = (PyString)o;
        return Arrays.equals(o2.rawstr, this.rawstr);
    }

    public boolean compare(PyObject o2) {
        return this.equals(o2);
    }
}

