/*
 * Decompiled with CFR 0.152.
 */
package prpobjects;

import prpobjects.BoundingBox;
import prpobjects.Rgba;
import prpobjects.Transmatrix;
import prpobjects.uruobj;
import shared.Flt;
import shared.e;
import shared.m;
import shared.readexception;
import uru.Bytedeque;
import uru.context;

public class plGeometrySpan
extends uruobj {
    Transmatrix localToWorld;
    Transmatrix worldToLocal;
    BoundingBox localBounds;
    Transmatrix OBBtoLocal;
    Transmatrix localToOBB;
    int baseMatrix;
    byte numMatrices;
    short localUVWChans;
    short maxBoneIdx;
    short penBoneIdx;
    Flt minDist;
    Flt maxDist;
    byte format;
    int props;
    int numVerts;
    int numIndices;
    int u1;
    byte b1;
    int decalLevel;
    Flt waterHeight;
    byte[] rawdata;
    Rgba[] colors;
    int[] diffuseRgba;
    int[] specularRgba;
    short[] indexData;
    int instanceGroup;

    public plGeometrySpan(context c) throws readexception {
        this.localToWorld = new Transmatrix(c);
        this.worldToLocal = new Transmatrix(c);
        this.localBounds = new BoundingBox(c);
        this.OBBtoLocal = new Transmatrix(c);
        this.localToOBB = new Transmatrix(c);
        this.baseMatrix = c.readInt();
        this.numMatrices = c.readByte();
        this.localUVWChans = c.readShort();
        this.maxBoneIdx = c.readShort();
        this.penBoneIdx = c.readShort();
        this.minDist = new Flt(c);
        this.maxDist = new Flt(c);
        this.format = c.readByte();
        this.props = c.readInt();
        this.numVerts = c.readInt();
        this.numIndices = c.readInt();
        this.u1 = c.readInt();
        this.b1 = c.readByte();
        this.decalLevel = c.readInt();
        if ((this.props & 0x800) != 0) {
            this.waterHeight = new Flt(c);
        }
        if (this.numVerts > 0) {
            int stride = ((this.format & 0xF) + 2) * 12;
            stride += ((this.format & 0x30) >> 4) * 4;
            if ((this.format & 0x40) != 0) {
                stride += 4;
            }
            this.rawdata = c.readBytes(stride * this.numVerts);
            this.colors = (Rgba[])c.readArray(Rgba.class, this.numVerts * 2);
            this.diffuseRgba = c.readInts(this.numVerts);
            this.specularRgba = c.readInts(this.numVerts);
        }
        this.indexData = c.readShorts(this.numIndices);
        this.instanceGroup = c.readInt();
        e.ensure(this.instanceGroup, 0);
        if (this.instanceGroup != 0) {
            m.err("Cannot currently handle PlGeometrySpans with non-zero instanceGroup count.");
        }
    }

    public void compile(Bytedeque c) {
        this.localToWorld.compile(c);
        this.worldToLocal.compile(c);
        this.localBounds.compile(c);
        this.OBBtoLocal.compile(c);
        this.localToOBB.compile(c);
        c.writeInt(this.baseMatrix);
        c.writeByte(this.numMatrices);
        c.writeShort(this.localUVWChans);
        c.writeShort(this.maxBoneIdx);
        c.writeShort(this.penBoneIdx);
        this.minDist.compile(c);
        this.maxDist.compile(c);
        c.writeByte(this.format);
        c.writeInt(this.props);
        c.writeInt(this.numVerts);
        c.writeInt(this.numIndices);
        c.writeInt(this.u1);
        c.writeByte(this.b1);
        c.writeInt(this.decalLevel);
        if ((this.props & 0x800) != 0) {
            this.waterHeight.compile(c);
        }
        if (this.numVerts > 0) {
            int stride = ((this.format & 0xF) + 2) * 12;
            stride += ((this.format & 0x30) >> 4) * 4;
            if ((this.format & 0x40) != 0) {
                stride += 4;
            }
            c.writeBytes(this.rawdata);
            c.writeArray2(this.colors);
            c.writeInts(this.diffuseRgba);
            c.writeInts(this.specularRgba);
        }
        c.writeShorts(this.indexData);
        c.writeInt(this.instanceGroup);
        if (this.instanceGroup != 0) {
            m.err("Cannot currently write PlGeometrySpans with non-zero instanceGroup count.");
        }
    }
}

