/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import org.pentaho.reporting.libraries.pixie.wmf.MfLogRegion;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.WmfObject;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;
import org.pentaho.reporting.libraries.pixie.wmf.records.RecordCreationException;

public class MfCmdSelectClipRegion
extends MfCmd {
    private static final int RECORD_SIZE = 1;
    private static final int POS_OBJECT_ID = 0;
    private int objectId;

    public void replay(WmfFile file) {
        WmfObject object = file.getObject(this.objectId);
        if (object == null) {
            throw new IllegalStateException("No Such Object defined: " + this.objectId);
        }
        switch (object.getType()) {
            case 5: {
                file.getCurrentState().setLogRegion((MfLogRegion)object);
                break;
            }
            default: {
                throw new IllegalStateException("Object is no region");
            }
        }
    }

    public MfCmd getInstance() {
        return new MfCmdSelectClipRegion();
    }

    public void setRecord(MfRecord record) {
        int id = record.getParam(0);
        this.setObjectId(id);
    }

    public MfRecord getRecord() throws RecordCreationException {
        MfRecord record = new MfRecord(1);
        record.setParam(0, this.getObjectId());
        return record;
    }

    public int getFunction() {
        return 300;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[SELECT_CLIPREGION] object=");
        b.append(this.getObjectId());
        return b.toString();
    }

    public void setObjectId(int id) {
        this.objectId = id;
    }

    protected void scaleXChanged() {
    }

    protected void scaleYChanged() {
    }
}

