/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure.describer;

import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDescriber;
import org.gradle.internal.component.IncompatibleGraphVariantsException;
import org.gradle.internal.component.model.AttributeDescriberSelector;
import org.gradle.internal.component.resolution.failure.ResolutionCandidateAssessor;
import org.gradle.internal.component.resolution.failure.describer.AbstractResolutionFailureDescriber;
import org.gradle.internal.component.resolution.failure.type.IncompatibleRequestedConfigurationFailure;
import org.gradle.internal.exceptions.StyledException;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.TreeFormatter;

public abstract class IncompatibleRequestedConfigurationFailureDescriber
extends AbstractResolutionFailureDescriber<IncompatibleGraphVariantsException, IncompatibleRequestedConfigurationFailure> {
    private static final String INCOMPATIBLE_VARIANTS_PREFIX = "Incompatible variant errors are explained in more detail at ";
    private static final String INCOMPATIBLE_VARIANTS_SECTION = "sub:variant-incompatible";

    @Override
    public IncompatibleGraphVariantsException describeFailure(IncompatibleRequestedConfigurationFailure failure) {
        AttributeDescriber describer = AttributeDescriberSelector.selectDescriber((AttributeContainerInternal)failure.getRequestedAttributes(), failure.getSchema());
        String message = this.buildIncompatibleGraphVariantsFailureMsg(failure, describer);
        IncompatibleGraphVariantsException e = new IncompatibleGraphVariantsException(message);
        e.addResolution(INCOMPATIBLE_VARIANTS_PREFIX + this.getDocumentationRegistry().getDocumentationFor("variant_model", INCOMPATIBLE_VARIANTS_SECTION) + ".");
        this.suggestReviewAlgorithm(e);
        return e;
    }

    private String buildIncompatibleGraphVariantsFailureMsg(IncompatibleRequestedConfigurationFailure failure, AttributeDescriber describer) {
        ResolutionCandidateAssessor.AssessedCandidate assessedCandidate = (ResolutionCandidateAssessor.AssessedCandidate)failure.getCandidates().get(0);
        TreeFormatter formatter = new TreeFormatter();
        String candidateName = assessedCandidate.getDisplayName();
        formatter.node("Configuration '" + candidateName + "' in " + StyledException.style((StyledTextOutput.Style)StyledTextOutput.Style.Info, (String)failure.getRequestedName()) + " does not match the consumer attributes");
        this.formatUnselectable(assessedCandidate, formatter, describer);
        return formatter.toString();
    }

    private void formatUnselectable(ResolutionCandidateAssessor.AssessedCandidate assessedCandidate, TreeFormatter formatter, AttributeDescriber describer) {
        formatter.node("Configuration '");
        formatter.append((CharSequence)assessedCandidate.getDisplayName());
        formatter.append((CharSequence)"'");
        this.formatAttributeMatchesForIncompatibility(assessedCandidate, formatter, describer);
    }
}

