/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.wizards;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.eclipse.ui.wizards.IWizardRegistry;
import org.xmind.ui.internal.wizards.ImportExportWizard;

public abstract class WizardHandler
extends AbstractHandler
implements IElementUpdater {
    protected abstract void executeHandler(ExecutionEvent var1);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String wizardId = event.getParameter(this.getWizardIdParameterId());
        IWorkbenchWindow activeWindow = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        if (wizardId == null) {
            this.executeHandler(event);
        } else {
            IWorkbenchWizard wizard;
            block6: {
                IWizardRegistry wizardRegistry = this.getWizardRegistry();
                IWizardDescriptor wizardDescriptor = wizardRegistry.findWizard(wizardId);
                if (wizardDescriptor == null) {
                    throw new ExecutionException("unknown wizard: " + wizardId);
                }
                try {
                    wizard = wizardDescriptor.createWizard();
                    wizard.init(PlatformUI.getWorkbench(), this.getSelectionToUse(event));
                    if (!wizardDescriptor.canFinishEarly() || wizardDescriptor.hasPages()) break block6;
                    wizard.performFinish();
                    return null;
                }
                catch (CoreException ex) {
                    throw new ExecutionException("error creating wizard", (Throwable)ex);
                }
            }
            Shell parent = activeWindow.getShell();
            WizardDialog dialog = new WizardDialog(parent, (IWizard)wizard);
            dialog.create();
            dialog.open();
        }
        return null;
    }

    protected IStructuredSelection getSelectionToUse(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    public void updateElement(UIElement element, Map parameters) {
        String wizardId = (String)parameters.get(this.getWizardIdParameterId());
        if (wizardId == null) {
            return;
        }
        IWizardDescriptor wizard = this.getWizardRegistry().findWizard(wizardId);
        if (wizard != null) {
            element.setText(NLS.bind((String)WorkbenchMessages.WizardHandler_menuLabel, (Object)wizard.getLabel()));
            element.setTooltip(wizard.getDescription());
            element.setIcon(wizard.getImageDescriptor());
        }
    }

    protected abstract String getWizardIdParameterId();

    protected abstract IWizardRegistry getWizardRegistry();

    public static final class Export
    extends WizardHandler {
        private static final int SIZING_WIZARD_WIDTH = 470;
        private static final int SIZING_WIZARD_HEIGHT = 550;

        @Override
        protected String getWizardIdParameterId() {
            return "exportWizardId";
        }

        @Override
        protected IWizardRegistry getWizardRegistry() {
            return PlatformUI.getWorkbench().getExportWizardRegistry();
        }

        @Override
        protected void executeHandler(ExecutionEvent event) {
            IWorkbenchWindow activeWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
            if (activeWorkbenchWindow == null) {
                return;
            }
            ImportExportWizard wizard = new ImportExportWizard("export");
            IStructuredSelection selectionToPass = this.getSelectionToUse(event);
            wizard.init(activeWorkbenchWindow.getWorkbench(), selectionToPass);
            IDialogSettings workbenchSettings = WorkbenchPlugin.getDefault().getDialogSettings();
            IDialogSettings wizardSettings = workbenchSettings.getSection("ImportExportAction");
            if (wizardSettings == null) {
                wizardSettings = workbenchSettings.addNewSection("ImportExportAction");
            }
            wizard.setDialogSettings(wizardSettings);
            wizard.setForcePreviousAndNextButtons(true);
            Shell parent = activeWorkbenchWindow.getShell();
            WizardDialog dialog = new WizardDialog(parent, (IWizard)wizard);
            dialog.create();
            dialog.getShell().setSize(Math.max(470, dialog.getShell().getSize().x), 550);
            activeWorkbenchWindow.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.ui.export_wizard_context");
            dialog.open();
        }
    }

    public static final class Import
    extends WizardHandler {
        private static final int SIZING_WIZARD_WIDTH = 470;
        private static final int SIZING_WIZARD_HEIGHT = 550;

        @Override
        protected String getWizardIdParameterId() {
            return "importWizardId";
        }

        @Override
        protected IWizardRegistry getWizardRegistry() {
            return PlatformUI.getWorkbench().getImportWizardRegistry();
        }

        @Override
        protected void executeHandler(ExecutionEvent event) {
            IWorkbenchWindow activeWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
            if (activeWorkbenchWindow == null) {
                return;
            }
            ImportExportWizard wizard = new ImportExportWizard("import");
            IStructuredSelection selectionToPass = this.getSelectionToUse(event);
            wizard.init(activeWorkbenchWindow.getWorkbench(), selectionToPass);
            IDialogSettings workbenchSettings = WorkbenchPlugin.getDefault().getDialogSettings();
            IDialogSettings wizardSettings = workbenchSettings.getSection("ImportExportAction");
            if (wizardSettings == null) {
                wizardSettings = workbenchSettings.addNewSection("ImportExportAction");
            }
            wizard.setDialogSettings(wizardSettings);
            wizard.setForcePreviousAndNextButtons(true);
            Shell parent = activeWorkbenchWindow.getShell();
            WizardDialog dialog = new WizardDialog(parent, (IWizard)wizard);
            dialog.create();
            dialog.getShell().setSize(Math.max(470, dialog.getShell().getSize().x), 550);
            activeWorkbenchWindow.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.ui.import_wizard_context");
            dialog.open();
        }
    }
}

