/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import java.util.HashMap;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.core.style.IStyle;
import org.xmind.gef.draw2d.graphics.GraphicsUtils;
import org.xmind.ui.internal.views.StyleFigureUtils;

public class StyleFigure
extends Figure {
    private static final Rectangle RECT = new Rectangle();
    private IStyle style;
    private HashMap<String, String> existedStyle;

    public IStyle getStyle() {
        return this.style;
    }

    public void setStyle(IStyle style) {
        if (style == this.style) {
            return;
        }
        this.style = style;
        this.repaint();
    }

    public void setExistedStyle(HashMap<String, String> existedStyle) {
        this.existedStyle = existedStyle;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        GraphicsUtils.fixGradientBugForCarbon((Graphics)graphics, (IFigure)this);
        super.paint(graphics);
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        this.drawStyle(graphics);
    }

    protected void drawStyle(Graphics graphics) {
        if (this.style == null) {
            return;
        }
        graphics.setAntialias(1);
        graphics.setTextAntialias(1);
        Rectangle r = this.getClientArea(RECT);
        this.drawStyle(graphics, this.style, r);
    }

    private void drawStyle(Graphics graphics, IStyle style, Rectangle r) {
        String type = style.getType();
        if ("topic".equalsIgnoreCase(type)) {
            StyleFigureUtils.drawTopic(graphics, r, this.existedStyle, style, null, false, false);
            StyleFigureUtils.drawStyleText(graphics, "Topic", r, this.existedStyle, style, StyleFigureUtils.defaultMainStyle);
        } else if ("boundary".equalsIgnoreCase(type)) {
            StyleFigureUtils.drawBoundary(graphics, r, this.existedStyle, style, null);
        } else if ("relationship".equalsIgnoreCase(type)) {
            StyleFigureUtils.drawRelationship(graphics, r, this.existedStyle, style, null);
        } else if ("map".equalsIgnoreCase(type)) {
            StyleFigureUtils.drawSheetBackground(graphics, r, this.existedStyle, style, null, true);
        }
    }
}

