/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;
import org.xmind.ui.gantt2.gefext.IBoundingPathProvider;
import org.xmind.ui.gantt2.gefext.PathDescriptor;
import org.xmind.ui.gantt2.viewer.Colors;
import org.xmind.ui.gantt2.viewer.OffsetFigure;
import org.xmind.ui.gantt2.viewer.TaskTreeItemPart;

public class TaskBarFigure
extends OffsetFigure
implements IBoundingPathProvider {
    public static final int STAT_CORNER = 6;
    public static final int FIGURE_CORNER = 2;
    public static final String PROP_CHECKPOINT = "checkpoint";
    private static final int CHECKPOINT_FLAG = MAX_FLAG << 1;
    private static final int CORNER = 4;
    private int length = 0;
    private PathDescriptor path;
    private boolean hasChild;

    public TaskBarFigure() {
        this.setForegroundColor(Colors.taskBar());
        this.setOpaque(false);
        this.updatePreferredSize();
    }

    public void setLength(int length) {
        if (length == this.length) {
            return;
        }
        this.length = length;
        this.updatePreferredSize();
    }

    public int getLength() {
        return this.length;
    }

    public void setHasChild(boolean hasChild) {
        if (this.hasChild != hasChild) {
            this.hasChild = hasChild;
            this.repaint();
        }
    }

    public boolean getHasChild() {
        return this.hasChild;
    }

    public boolean isCheckpoint() {
        return this.getFlag(CHECKPOINT_FLAG);
    }

    public void setCheckpoint(boolean value) {
        if (value == this.isCheckpoint()) {
            return;
        }
        boolean oldValue = this.isCheckpoint();
        this.setFlag(CHECKPOINT_FLAG, value);
        this.updatePreferredSize();
        this.firePropertyChange(PROP_CHECKPOINT, oldValue, this.isCheckpoint());
    }

    private void updatePreferredSize() {
        if (this.isCheckpoint()) {
            this.setPreferredSize(12, TaskTreeItemPart.HEIGHT);
        } else {
            this.setPreferredSize(this.getLength(), TaskTreeItemPart.HEIGHT);
        }
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        graphics.setBackgroundColor(graphics.getForegroundColor());
        if (this.isCheckpoint()) {
            this.paintCheckPoint(graphics);
        } else if (this.hasChild) {
            this.paintStatistics(graphics);
        } else {
            this.paintTaskBar(graphics);
        }
    }

    private void paintTaskBar(Graphics graphics) {
        Rectangle r = this.getBounds();
        graphics.fillRoundRectangle(new Rectangle(r.x, r.y + 3, r.width, r.height - 6), 2, 2);
    }

    public boolean containsPoint(int x, int y) {
        return this.hasOffset() && super.containsPoint(x, y);
    }

    public void invalidate() {
        super.invalidate();
        this.path = null;
    }

    protected void primTranslate(int dx, int dy) {
        super.primTranslate(dx, dy);
        this.path = null;
    }

    public PathDescriptor getBoundingPath() {
        if (this.path == null) {
            this.path = this.createBoundingPath();
        }
        return this.path;
    }

    private PathDescriptor createBoundingPath() {
        PathDescriptor path = new PathDescriptor();
        Rectangle r = this.getBounds();
        if (this.isCheckpoint()) {
            double cx = (double)r.x + (double)r.width * 0.5;
            double cy = (double)r.y + (double)r.height * 0.5;
            path.moveTo(cx, r.y);
            path.lineTo(r.x, cy);
            path.lineTo(cx, r.y + r.height);
            path.lineTo(r.x + r.width, cy);
            path.lineTo(cx, r.y);
            path.close();
        } else {
            Rectangle r1 = new Rectangle(r.x, r.y + (TaskTreeItemPart.HEIGHT - 12) / 2, r.width, 12);
            path.addRoundedRectangle(r1, 4.0);
        }
        return path;
    }

    private void paintStatistics(Graphics graphics) {
        Rectangle bounds = this.getBounds();
        Rectangle r = new Rectangle(bounds);
        r.y += 2;
        if (r.width == 0 || r.height == 0) {
            return;
        }
        Path path = new Path((Device)Display.getCurrent());
        try {
            float corner = 0.5f;
            path.moveTo((float)r.x - corner, (float)(r.y + (TaskTreeItemPart.HEIGHT - 12) / 2) - corner);
            path.lineTo((float)(r.x + r.width) - corner + 1.0f, (float)(r.y + (TaskTreeItemPart.HEIGHT - 12) / 2) - corner);
            path.lineTo((float)(r.x + r.width) - corner + 1.0f, (float)(r.y + (TaskTreeItemPart.HEIGHT - 12) / 2 + 12) - corner);
            path.lineTo((float)(r.x + r.width - 6) + corner + 1.0f, (float)(r.y + (TaskTreeItemPart.HEIGHT - 12) / 2 + 12 - 6) + corner);
            path.lineTo((float)(r.x + 6) + corner, (float)(r.y + (TaskTreeItemPart.HEIGHT - 12) / 2 + 12 - 6) - corner);
            path.lineTo((float)r.x - corner, (float)(r.y + (TaskTreeItemPart.HEIGHT - 12) / 2 + 12) + corner);
            path.lineTo((float)r.x - corner, (float)(r.y + (TaskTreeItemPart.HEIGHT - 12) / 2) - corner);
            graphics.fillPath(path);
        }
        finally {
            path.dispose();
        }
    }

    private void paintCheckPoint(Graphics graphics) {
        Rectangle bounds = this.getBounds();
        Rectangle r = new Rectangle(bounds);
        if (r.width == 0 || r.height == 0) {
            return;
        }
        PathDescriptor pathDescriptor = new PathDescriptor();
        double cx = (double)r.x + (double)r.width * 0.5;
        double cy = (double)r.y + (double)r.height * 0.5;
        pathDescriptor.moveTo(cx, r.y);
        pathDescriptor.lineTo(r.x, cy);
        pathDescriptor.lineTo(cx, r.y + r.height);
        pathDescriptor.lineTo(r.x + r.width, cy);
        pathDescriptor.lineTo(cx, r.y);
        pathDescriptor.close();
        Path path = new Path((Device)Display.getCurrent());
        try {
            pathDescriptor.applyTo(path);
            graphics.fillPath(path);
        }
        finally {
            path.dispose();
        }
    }
}

