# txEdgeOrtho.sql was originally generated by the autoSql program, which also 
# generated txEdgeOrtho.c and txEdgeOrtho.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#A transcription edge with additional orthology information.
CREATE TABLE txEdgeOrtho (
    chrom varchar(255) not null,	# Chromosome or contig name
    chromStart int not null,	# Start position, zero-based
    chromEnd int not null,	# End position, non-inclusive
    name varchar(255) not null,	# Name of txGraph in other organism
    score int not null,	# Parts per thousand of edge that align
    strand char(1) not null,	# Strand - either plus or minus
    startType char(1) not null,	# [ or ( for hard or soft
    type enum("exon", "intron") not null,	# edge type
    endType char(1) not null,	# ] or ) for hard or soft
    mappedChrom varchar(255) not null,	# Chromosome in other organism
    mappedStart int not null,	# ChromStart mapped to other organism
    mappedEnd int not null,	# ChromEnd mapped to other organism
    txGraph varchar(255) not null,	# Transcription graph name in this organism
    overlapScore int not null,	# Parts per thousand of mapped/ortho overlap
    orthoStrand char(1) not null,	# Strand of orthologous txGraph
    orthoStartType char(1) not null,	# Is orthologous start hard/soft?
    orthoEndType char(1) not null,	# Is orthologous end hard/soft?
    orthoStart int not null,	# Start of orthologous edge (based on RNA in other species)
    orthoEnd int not null,	# End of orthologous edge (based on RNA in other species)
              #Indices
    PRIMARY KEY(name(12))
);
