/* mouseSynWhd.c was originally generated by the autoSql program, which also 
 * generated mouseSynWhd.h and mouseSynWhd.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "mouseSynWhd.h"


void mouseSynWhdStaticLoad(char **row, struct mouseSynWhd *ret)
/* Load a row from mouseSynWhd table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->score = sqlUnsigned(row[4]);
strcpy(ret->strand, row[5]);
ret->mouseStart = sqlUnsigned(row[6]);
ret->mouseEnd = sqlUnsigned(row[7]);
ret->segLabel = row[8];
}

struct mouseSynWhd *mouseSynWhdLoad(char **row)
/* Load a mouseSynWhd from row fetched with select * from mouseSynWhd
 * from database.  Dispose of this with mouseSynWhdFree(). */
{
struct mouseSynWhd *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
strcpy(ret->strand, row[5]);
ret->mouseStart = sqlUnsigned(row[6]);
ret->mouseEnd = sqlUnsigned(row[7]);
ret->segLabel = cloneString(row[8]);
return ret;
}

struct mouseSynWhd *mouseSynWhdLoadAll(char *fileName) 
/* Load all mouseSynWhd from a tab-separated file.
 * Dispose of this with mouseSynWhdFreeList(). */
{
struct mouseSynWhd *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[9];

while (lineFileRow(lf, row))
    {
    el = mouseSynWhdLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct mouseSynWhd *mouseSynWhdLoadWhere(struct sqlConnection *conn, char *table, char *where)
/* Load all mouseSynWhd from table that satisfy where clause. The
 * where clause may be NULL in which case whole table is loaded
 * Dispose of this with mouseSynWhdFreeList(). */
{
struct mouseSynWhd *list = NULL, *el;
struct dyString *query = dyStringNew(256);
struct sqlResult *sr;
char **row;

dyStringPrintf(query, "select * from %s", table);
if (where != NULL)
    dyStringPrintf(query, " where %s", where);
sr = sqlGetResult(conn, query->string);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = mouseSynWhdLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
dyStringFree(&query);
return list;
}

struct mouseSynWhd *mouseSynWhdCommaIn(char **pS, struct mouseSynWhd *ret)
/* Create a mouseSynWhd out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new mouseSynWhd */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->mouseStart = sqlUnsignedComma(&s);
ret->mouseEnd = sqlUnsignedComma(&s);
ret->segLabel = sqlStringComma(&s);
*pS = s;
return ret;
}

void mouseSynWhdFree(struct mouseSynWhd **pEl)
/* Free a single dynamically allocated mouseSynWhd such as created
 * with mouseSynWhdLoad(). */
{
struct mouseSynWhd *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->segLabel);
freez(pEl);
}

void mouseSynWhdFreeList(struct mouseSynWhd **pList)
/* Free a list of dynamically allocated mouseSynWhd's */
{
struct mouseSynWhd *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    mouseSynWhdFree(&el);
    }
*pList = NULL;
}

void mouseSynWhdOutput(struct mouseSynWhd *el, FILE *f, char sep, char lastSep) 
/* Print out mouseSynWhd.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->mouseStart);
fputc(sep,f);
fprintf(f, "%u", el->mouseEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->segLabel);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

